<?php
$item     = $context['item']; // phpcs:ignore VariableAnalysis.CodeAnalysis.VariableAnalysis.UndefinedVariable
$add_link = 'none' !== $this->link;

// We do this for accessibility.  Titles without alt's break screen readers.
if ( empty( $item->image_alt ) && ! empty( $item->image_title ) ) {
	$item->image_alt = $item->image_title;
}
?>
<div class="tiled-gallery-item<?php if ( isset( $item->size ) ) echo " tiled-gallery-item-$item->size"; ?>" itemprop="associatedMedia" itemscope itemtype="http://schema.org/ImageObject">
	<?php if ( $add_link ): ?>
	<a href="<?php echo esc_url( $item->link ) ?>" border="0" itemprop="url">
	<?php endif; ?>
		<meta itemprop="width" content="<?php echo esc_attr( $item->image->width ); ?>">
		<meta itemprop="height" content="<?php echo esc_attr( $item->image->height ); ?>">
		<?php ob_start() ?>
		<img
			<?php $this->partial( 'carousel-image-args', array( 'item' => $item ) ); ?>
			src="<?php echo esc_url( $item->img_src ); ?>"
			<?php if ( Jetpack::is_development_mode() ) : ?>
				srcset="<?php echo esc_attr( wp_get_attachment_image_srcset( $item->image->ID, 'full' ) ); ?>"
				sizes="<?php echo esc_attr( wp_calculate_image_sizes( array( $item->image->width, $item->image->height ) ) ); ?>"
			<?php endif ?>
			width="<?php echo esc_attr( $item->image->width ); ?>"
			height="<?php echo esc_attr( $item->image->height ); ?>"
			data-original-width="<?php echo esc_attr( $item->image->width ); ?>"
			data-original-height="<?php echo esc_attr( $item->image->height ); ?>"
			itemprop="http://schema.org/image"
			title="<?php echo esc_attr( $item->image_title ); ?>"
			alt="<?php echo esc_attr( $item->image_alt ); ?>"
			style="width: <?php echo esc_attr( $item->image->width ); ?>px; height: <?php echo esc_attr( $item->image->height ); ?>px;"
		/>
		<?php echo VamtamOverrides::maybe_lazyload( ob_get_clean(), $item->image->ID, 'full', false ) ?>
	<?php if ( $add_link ): ?>
	</a>
	<?php endif; ?>

	<?php if ( $this->grayscale == true ): ?>
		<?php if ( $add_link ): ?>
		<a href="<?php echo esc_url( $item->link ) ?>" border="0" itemprop="url">
		<?php endif; ?>
			<meta itemprop="width" content="<?php echo esc_attr( $item->image->width ); ?>">
			<meta itemprop="height" content="<?php echo esc_attr( $item->image->height ); ?>">
			<img
				class="grayscale"
				src="<?php echo esc_url( $item->img_src_grayscale ); ?>"
				width="<?php echo esc_attr( $item->image->width ); ?>"
				height="<?php echo esc_attr( $item->image->height ); ?>"
				data-original-width="<?php echo esc_attr( $item->image->width ); ?>"
				data-original-height="<?php echo esc_attr( $item->image->height ); ?>"
				itemprop="http://schema.org/image"
				title="<?php echo esc_attr( $item->image_title ); ?>"
				align="left"
				alt="<?php echo esc_attr( $item->image_alt ); ?>"
				style="width: <?php echo esc_attr( $item->image->width ); ?>px; height: <?php echo esc_attr( $item->image->height ); ?>px;"
			/>
		<?php if ( $add_link ): ?>
		</a>
		<?php endif; ?>
	<?php endif; ?>

	<?php if ( trim( $item->image->post_excerpt ) ): ?>
		<div class="tiled-gallery-caption" itemprop="caption description">
			<?php echo wptexturize( $item->image->post_excerpt ); ?>
		</div>
	<?php endif; ?>
</div>
