"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

/*!
 * Generated using the Bootstrap Customizer (http://getbootstrap.com/customize/?id=f4b4c9cb85df757ca08c)
 * Config saved to config.json and https://gist.github.com/f4b4c9cb85df757ca08c
 */
if (typeof jQuery === 'undefined') {
  throw new Error('Bootstrap\'s JavaScript requires jQuery');
}

+function ($) {
  'use strict';

  var version = $.fn.jquery.split(' ')[0].split('.');

  if (version[0] < 2 && version[1] < 9 || version[0] == 1 && version[1] == 9 && version[2] < 1) {
    throw new Error('Bootstrap\'s JavaScript requires jQuery version 1.9.1 or higher');
  }
}(jQuery);
/* ========================================================================
 * Bootstrap: modal.js v3.3.5
 * http://getbootstrap.com/javascript/#modals
 * ========================================================================
 * Copyright 2011-2015 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */

+function ($) {
  'use strict'; // MODAL CLASS DEFINITION
  // ======================

  var Modal = function Modal(element, options) {
    this.options = options;
    this.$body = $(document.body);
    this.$element = $(element);
    this.$dialog = this.$element.find('.modal-dialog');
    this.$backdrop = null;
    this.isShown = null;
    this.originalBodyPad = null;
    this.scrollbarWidth = 0;
    this.ignoreBackdropClick = false;

    if (this.options.remote) {
      this.$element.find('.modal-content').load(this.options.remote, $.proxy(function () {
        this.$element.trigger('loaded.wpbc.modal');
      }, this));
    }
  };

  Modal.VERSION = '3.3.5';
  Modal.TRANSITION_DURATION = 300;
  Modal.BACKDROP_TRANSITION_DURATION = 150;
  Modal.DEFAULTS = {
    backdrop: true,
    keyboard: true,
    show: true
  };

  Modal.prototype.toggle = function (_relatedTarget) {
    return this.isShown ? this.hide() : this.show(_relatedTarget);
  };

  Modal.prototype.show = function (_relatedTarget) {
    var that = this;
    var e = $.Event('show.wpbc.modal', {
      relatedTarget: _relatedTarget
    });
    this.$element.trigger(e);
    if (this.isShown || e.isDefaultPrevented()) return;
    this.isShown = true;
    this.checkScrollbar();
    this.setScrollbar();
    this.$body.addClass('modal-open');
    this.escape();
    this.resize();
    this.$element.on('click.dismiss.wpbc.modal', '[data-dismiss="modal"]', $.proxy(this.hide, this));
    this.$dialog.on('mousedown.dismiss.wpbc.modal', function () {
      that.$element.one('mouseup.dismiss.wpbc.modal', function (e) {
        if ($(e.target).is(that.$element)) that.ignoreBackdropClick = true;
      });
    });
    this.backdrop(function () {
      var transition = $.support.transition && that.$element.hasClass('fade');

      if (!that.$element.parent().length) {
        that.$element.appendTo(that.$body); // don't move modals dom position
      }

      that.$element.show().scrollTop(0);
      that.adjustDialog();

      if (transition) {
        that.$element[0].offsetWidth; // force reflow
      }

      that.$element.addClass('in');
      that.enforceFocus();
      var e = $.Event('shown.wpbc.modal', {
        relatedTarget: _relatedTarget
      });
      transition ? that.$dialog // wait for modal to slide in
      .one('bsTransitionEnd', function () {
        that.$element.trigger('focus').trigger(e);
      }).emulateTransitionEnd(Modal.TRANSITION_DURATION) : that.$element.trigger('focus').trigger(e);
    });
  };

  Modal.prototype.hide = function (e) {
    if (e) e.preventDefault();
    e = $.Event('hide.wpbc.modal');
    this.$element.trigger(e);
    if (!this.isShown || e.isDefaultPrevented()) return;
    this.isShown = false;
    this.escape();
    this.resize();
    $(document).off('focusin.wpbc.modal');
    this.$element.removeClass('in').off('click.dismiss.wpbc.modal').off('mouseup.dismiss.wpbc.modal');
    this.$dialog.off('mousedown.dismiss.wpbc.modal');
    $.support.transition && this.$element.hasClass('fade') ? this.$element.one('bsTransitionEnd', $.proxy(this.hideModal, this)).emulateTransitionEnd(Modal.TRANSITION_DURATION) : this.hideModal();
  };

  Modal.prototype.enforceFocus = function () {
    $(document).off('focusin.wpbc.modal') // guard against infinite focus loop
    .on('focusin.wpbc.modal', $.proxy(function (e) {
      if (this.$element[0] !== e.target && !this.$element.has(e.target).length) {
        this.$element.trigger('focus');
      }
    }, this));
  };

  Modal.prototype.escape = function () {
    if (this.isShown && this.options.keyboard) {
      this.$element.on('keydown.dismiss.wpbc.modal', $.proxy(function (e) {
        e.which == 27 && this.hide();
      }, this));
    } else if (!this.isShown) {
      this.$element.off('keydown.dismiss.wpbc.modal');
    }
  };

  Modal.prototype.resize = function () {
    if (this.isShown) {
      $(window).on('resize.wpbc.modal', $.proxy(this.handleUpdate, this));
    } else {
      $(window).off('resize.wpbc.modal');
    }
  };

  Modal.prototype.hideModal = function () {
    var that = this;
    this.$element.hide();
    this.backdrop(function () {
      that.$body.removeClass('modal-open');
      that.resetAdjustments();
      that.resetScrollbar();
      that.$element.trigger('hidden.wpbc.modal');
    });
  };

  Modal.prototype.removeBackdrop = function () {
    this.$backdrop && this.$backdrop.remove();
    this.$backdrop = null;
  };

  Modal.prototype.backdrop = function (callback) {
    var that = this;
    var animate = this.$element.hasClass('fade') ? 'fade' : '';

    if (this.isShown && this.options.backdrop) {
      var doAnimate = $.support.transition && animate;
      this.$backdrop = $(document.createElement('div')).addClass('modal-backdrop ' + animate).appendTo(this.$body);
      this.$element.on('click.dismiss.wpbc.modal', $.proxy(function (e) {
        if (this.ignoreBackdropClick) {
          this.ignoreBackdropClick = false;
          return;
        }

        if (e.target !== e.currentTarget) return;
        this.options.backdrop == 'static' ? this.$element[0].focus() : this.hide();
      }, this));
      if (doAnimate) this.$backdrop[0].offsetWidth; // force reflow

      this.$backdrop.addClass('in');
      if (!callback) return;
      doAnimate ? this.$backdrop.one('bsTransitionEnd', callback).emulateTransitionEnd(Modal.BACKDROP_TRANSITION_DURATION) : callback();
    } else if (!this.isShown && this.$backdrop) {
      this.$backdrop.removeClass('in');

      var callbackRemove = function callbackRemove() {
        that.removeBackdrop();
        callback && callback();
      };

      $.support.transition && this.$element.hasClass('fade') ? this.$backdrop.one('bsTransitionEnd', callbackRemove).emulateTransitionEnd(Modal.BACKDROP_TRANSITION_DURATION) : callbackRemove();
    } else if (callback) {
      callback();
    }
  }; // these following methods are used to handle overflowing modals


  Modal.prototype.handleUpdate = function () {
    this.adjustDialog();
  };

  Modal.prototype.adjustDialog = function () {
    var modalIsOverflowing = this.$element[0].scrollHeight > document.documentElement.clientHeight;
    this.$element.css({
      paddingLeft: !this.bodyIsOverflowing && modalIsOverflowing ? this.scrollbarWidth : '',
      paddingRight: this.bodyIsOverflowing && !modalIsOverflowing ? this.scrollbarWidth : ''
    });
  };

  Modal.prototype.resetAdjustments = function () {
    this.$element.css({
      paddingLeft: '',
      paddingRight: ''
    });
  };

  Modal.prototype.checkScrollbar = function () {
    var fullWindowWidth = window.innerWidth;

    if (!fullWindowWidth) {
      // workaround for missing window.innerWidth in IE8
      var documentElementRect = document.documentElement.getBoundingClientRect();
      fullWindowWidth = documentElementRect.right - Math.abs(documentElementRect.left);
    }

    this.bodyIsOverflowing = document.body.clientWidth < fullWindowWidth;
    this.scrollbarWidth = this.measureScrollbar();
  };

  Modal.prototype.setScrollbar = function () {
    var bodyPad = parseInt(this.$body.css('padding-right') || 0, 10);
    this.originalBodyPad = document.body.style.paddingRight || '';
    if (this.bodyIsOverflowing) this.$body.css('padding-right', bodyPad + this.scrollbarWidth);
  };

  Modal.prototype.resetScrollbar = function () {
    this.$body.css('padding-right', this.originalBodyPad);
  };

  Modal.prototype.measureScrollbar = function () {
    // thx walsh
    var scrollDiv = document.createElement('div');
    scrollDiv.className = 'modal-scrollbar-measure';
    this.$body.append(scrollDiv);
    var scrollbarWidth = scrollDiv.offsetWidth - scrollDiv.clientWidth;
    this.$body[0].removeChild(scrollDiv);
    return scrollbarWidth;
  }; // MODAL PLUGIN DEFINITION
  // =======================


  function Plugin(option, _relatedTarget) {
    return this.each(function () {
      var $this = $(this);
      var data = $this.data('wpbc.modal');
      var options = $.extend({}, Modal.DEFAULTS, $this.data(), _typeof(option) == 'object' && option);
      if (!data) $this.data('wpbc.modal', data = new Modal(this, options));
      if (typeof option == 'string') data[option](_relatedTarget);else if (options.show) data.show(_relatedTarget);
    });
  }

  var old = $.fn.wpbc_my_modal;
  $.fn.wpbc_my_modal = Plugin;
  $.fn.wpbc_my_modal.Constructor = Modal; // MODAL NO CONFLICT
  // =================

  $.fn.wpbc_my_modal.noConflict = function () {
    $.fn.wpbc_my_modal = old;
    return this;
  }; // MODAL DATA-API
  // ==============


  $(document).on('click.wpbc.modal.data-api', '[data-toggle="wpbc_my_modal"]', function (e) {
    var $this = $(this);
    var href = $this.attr('href');
    var $target = $($this.attr('data-target') || href && href.replace(/.*(?=#[^\s]+$)/, '')); // strip for ie7

    var option = $target.data('wpbc.modal') ? 'toggle' : $.extend({
      remote: !/#/.test(href) && href
    }, $target.data(), $this.data());
    if ($this.is('a')) e.preventDefault();
    $target.one('show.wpbc.modal', function (showEvent) {
      if (showEvent.isDefaultPrevented()) return; // only register focus restorer if modal will actually get shown

      $target.one('hidden.wpbc.modal', function () {
        $this.is(':visible') && $this.trigger('focus');
      });
    });
    Plugin.call($target, option, this);
  });
}(jQuery);
+function ($) {
  'use strict'; // DROPDOWN CLASS DEFINITION
  // =========================

  var backdrop = '.dropdown-backdrop';
  var toggle = '[data-toggle="wpbc_dropdown"]';

  var Dropdown = function Dropdown(element) {
    $(element).on('click.wpbc.dropdown', this.toggle);
  };

  Dropdown.VERSION = '3.3.5';

  function getParent($this) {
    var selector = $this.attr('data-target');

    if (!selector) {
      selector = $this.attr('href');
      selector = selector && /#[A-Za-z]/.test(selector) && selector.replace(/.*(?=#[^\s]*$)/, ''); // strip for ie7
    }

    var $parent = selector && $(selector);
    return $parent && $parent.length ? $parent : $this.parent();
  }

  function clearMenus(e) {
    if (e && e.which === 3) return;
    $(backdrop).remove();
    $(toggle).each(function () {
      var $this = $(this);
      var $parent = getParent($this);
      var relatedTarget = {
        relatedTarget: this
      };
      if (!$parent.hasClass('open')) return;
      if (e && e.type == 'click' && /input|textarea/i.test(e.target.tagName) && $.contains($parent[0], e.target)) return;
      $parent.trigger(e = $.Event('hide.wpbc.dropdown', relatedTarget));
      if (e.isDefaultPrevented()) return;
      $this.attr('aria-expanded', 'false');
      $parent.removeClass('open').trigger('hidden.wpbc.dropdown', relatedTarget);
    });
  }

  Dropdown.prototype.toggle = function (e) {
    var $this = $(this);
    if ($this.is('.disabled, :disabled')) return;
    var $parent = getParent($this);
    var isActive = $parent.hasClass('open');
    clearMenus();

    if (!isActive) {
      if ('ontouchstart' in document.documentElement && !$parent.closest('.navbar-nav').length) {
        // if mobile we use a backdrop because click events don't delegate
        $(document.createElement('div')).addClass('dropdown-backdrop').insertAfter($(this)).on('click', clearMenus);
      }

      var relatedTarget = {
        relatedTarget: this
      };
      $parent.trigger(e = $.Event('show.wpbc.dropdown', relatedTarget));
      if (e.isDefaultPrevented()) return;
      $this.trigger('focus').attr('aria-expanded', 'true');
      $parent.toggleClass('open').trigger('shown.wpbc.dropdown', relatedTarget);
    }

    return false;
  };

  Dropdown.prototype.keydown = function (e) {
    if (!/(38|40|27|32)/.test(e.which) || /input|textarea/i.test(e.target.tagName)) return;
    var $this = $(this);
    e.preventDefault();
    e.stopPropagation();
    if ($this.is('.disabled, :disabled')) return;
    var $parent = getParent($this);
    var isActive = $parent.hasClass('open');

    if (!isActive && e.which != 27 || isActive && e.which == 27) {
      if (e.which == 27) $parent.find(toggle).trigger('focus');
      return $this.trigger('click');
    }

    var desc = ' li:not(.disabled):visible a';
    var $items = $parent.find('.dropdown-menu' + desc + ',.ui_dropdown_menu' + desc);
    if (!$items.length) return;
    var index = $items.index(e.target);
    if (e.which == 38 && index > 0) index--; // up

    if (e.which == 40 && index < $items.length - 1) index++; // down

    if (!~index) index = 0;
    $items.eq(index).trigger('focus');
  }; // DROPDOWN PLUGIN DEFINITION
  // ==========================


  function Plugin(option) {
    return this.each(function () {
      var $this = $(this);
      var data = $this.data('wpbc.dropdown');
      if (!data) $this.data('wpbc.dropdown', data = new Dropdown(this));
      if (typeof option == 'string') data[option].call($this);
    });
  }

  var old = $.fn.wpbc_dropdown;
  $.fn.wpbc_dropdown = Plugin;
  $.fn.wpbc_dropdown.Constructor = Dropdown; // DROPDOWN NO CONFLICT
  // ====================

  $.fn.wpbc_dropdown.noConflict = function () {
    $.fn.wpbc_dropdown = old;
    return this;
  }; // APPLY TO STANDARD DROPDOWN ELEMENTS
  // ===================================


  $(document).on('click.wpbc.dropdown.data-api', clearMenus).on('click.wpbc.dropdown.data-api', '.dropdown form', function (e) {
    e.stopPropagation();
  }).on('click.wpbc.dropdown.data-api', toggle, Dropdown.prototype.toggle).on('keydown.wpbc.dropdown.data-api', toggle, Dropdown.prototype.keydown).on('keydown.wpbc.dropdown.data-api', '.dropdown-menu', Dropdown.prototype.keydown).on('keydown.wpbc.dropdown.data-api', '.ui_dropdown_menu', Dropdown.prototype.keydown);
}(jQuery);
//# sourceMappingURL=data:application/json;charset=utf8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFzc2V0cy9saWJzL3VpL19zcmMvZHJvcGRvd25fbW9kYWwuanMiXSwibmFtZXMiOlsialF1ZXJ5IiwiRXJyb3IiLCIkIiwidmVyc2lvbiIsImZuIiwianF1ZXJ5Iiwic3BsaXQiLCJNb2RhbCIsImVsZW1lbnQiLCJvcHRpb25zIiwiJGJvZHkiLCJkb2N1bWVudCIsImJvZHkiLCIkZWxlbWVudCIsIiRkaWFsb2ciLCJmaW5kIiwiJGJhY2tkcm9wIiwiaXNTaG93biIsIm9yaWdpbmFsQm9keVBhZCIsInNjcm9sbGJhcldpZHRoIiwiaWdub3JlQmFja2Ryb3BDbGljayIsInJlbW90ZSIsImxvYWQiLCJwcm94eSIsInRyaWdnZXIiLCJWRVJTSU9OIiwiVFJBTlNJVElPTl9EVVJBVElPTiIsIkJBQ0tEUk9QX1RSQU5TSVRJT05fRFVSQVRJT04iLCJERUZBVUxUUyIsImJhY2tkcm9wIiwia2V5Ym9hcmQiLCJzaG93IiwicHJvdG90eXBlIiwidG9nZ2xlIiwiX3JlbGF0ZWRUYXJnZXQiLCJoaWRlIiwidGhhdCIsImUiLCJFdmVudCIsInJlbGF0ZWRUYXJnZXQiLCJpc0RlZmF1bHRQcmV2ZW50ZWQiLCJjaGVja1Njcm9sbGJhciIsInNldFNjcm9sbGJhciIsImFkZENsYXNzIiwiZXNjYXBlIiwicmVzaXplIiwib24iLCJvbmUiLCJ0YXJnZXQiLCJpcyIsInRyYW5zaXRpb24iLCJzdXBwb3J0IiwiaGFzQ2xhc3MiLCJwYXJlbnQiLCJsZW5ndGgiLCJhcHBlbmRUbyIsInNjcm9sbFRvcCIsImFkanVzdERpYWxvZyIsIm9mZnNldFdpZHRoIiwiZW5mb3JjZUZvY3VzIiwiZW11bGF0ZVRyYW5zaXRpb25FbmQiLCJwcmV2ZW50RGVmYXVsdCIsIm9mZiIsInJlbW92ZUNsYXNzIiwiaGlkZU1vZGFsIiwiaGFzIiwid2hpY2giLCJ3aW5kb3ciLCJoYW5kbGVVcGRhdGUiLCJyZXNldEFkanVzdG1lbnRzIiwicmVzZXRTY3JvbGxiYXIiLCJyZW1vdmVCYWNrZHJvcCIsInJlbW92ZSIsImNhbGxiYWNrIiwiYW5pbWF0ZSIsImRvQW5pbWF0ZSIsImNyZWF0ZUVsZW1lbnQiLCJjdXJyZW50VGFyZ2V0IiwiZm9jdXMiLCJjYWxsYmFja1JlbW92ZSIsIm1vZGFsSXNPdmVyZmxvd2luZyIsInNjcm9sbEhlaWdodCIsImRvY3VtZW50RWxlbWVudCIsImNsaWVudEhlaWdodCIsImNzcyIsInBhZGRpbmdMZWZ0IiwiYm9keUlzT3ZlcmZsb3dpbmciLCJwYWRkaW5nUmlnaHQiLCJmdWxsV2luZG93V2lkdGgiLCJpbm5lcldpZHRoIiwiZG9jdW1lbnRFbGVtZW50UmVjdCIsImdldEJvdW5kaW5nQ2xpZW50UmVjdCIsInJpZ2h0IiwiTWF0aCIsImFicyIsImxlZnQiLCJjbGllbnRXaWR0aCIsIm1lYXN1cmVTY3JvbGxiYXIiLCJib2R5UGFkIiwicGFyc2VJbnQiLCJzdHlsZSIsInNjcm9sbERpdiIsImNsYXNzTmFtZSIsImFwcGVuZCIsInJlbW92ZUNoaWxkIiwiUGx1Z2luIiwib3B0aW9uIiwiZWFjaCIsIiR0aGlzIiwiZGF0YSIsImV4dGVuZCIsIm9sZCIsIndwYmNfbXlfbW9kYWwiLCJDb25zdHJ1Y3RvciIsIm5vQ29uZmxpY3QiLCJocmVmIiwiYXR0ciIsIiR0YXJnZXQiLCJyZXBsYWNlIiwidGVzdCIsInNob3dFdmVudCIsImNhbGwiLCJEcm9wZG93biIsImdldFBhcmVudCIsInNlbGVjdG9yIiwiJHBhcmVudCIsImNsZWFyTWVudXMiLCJ0eXBlIiwidGFnTmFtZSIsImNvbnRhaW5zIiwiaXNBY3RpdmUiLCJjbG9zZXN0IiwiaW5zZXJ0QWZ0ZXIiLCJ0b2dnbGVDbGFzcyIsImtleWRvd24iLCJzdG9wUHJvcGFnYXRpb24iLCJkZXNjIiwiJGl0ZW1zIiwiaW5kZXgiLCJlcSIsIndwYmNfZHJvcGRvd24iXSwibWFwcGluZ3MiOiI7Ozs7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLElBQUksT0FBT0EsTUFBUCxLQUFrQixXQUF0QixFQUFtQztBQUNqQyxRQUFNLElBQUlDLEtBQUosQ0FBVSx5Q0FBVixDQUFOO0FBQ0Q7O0FBQ0QsQ0FBQyxVQUFVQyxDQUFWLEVBQWE7QUFDWjs7QUFDQSxNQUFJQyxPQUFPLEdBQUdELENBQUMsQ0FBQ0UsRUFBRixDQUFLQyxNQUFMLENBQVlDLEtBQVosQ0FBa0IsR0FBbEIsRUFBdUIsQ0FBdkIsRUFBMEJBLEtBQTFCLENBQWdDLEdBQWhDLENBQWQ7O0FBQ0EsTUFBS0gsT0FBTyxDQUFDLENBQUQsQ0FBUCxHQUFhLENBQWIsSUFBa0JBLE9BQU8sQ0FBQyxDQUFELENBQVAsR0FBYSxDQUFoQyxJQUF1Q0EsT0FBTyxDQUFDLENBQUQsQ0FBUCxJQUFjLENBQWQsSUFBbUJBLE9BQU8sQ0FBQyxDQUFELENBQVAsSUFBYyxDQUFqQyxJQUFzQ0EsT0FBTyxDQUFDLENBQUQsQ0FBUCxHQUFhLENBQTlGLEVBQWtHO0FBQ2hHLFVBQU0sSUFBSUYsS0FBSixDQUFVLGlFQUFWLENBQU47QUFDRDtBQUNGLENBTkEsQ0FNQ0QsTUFORCxDQUFEO0FBUUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBR0EsQ0FBQyxVQUFVRSxDQUFWLEVBQWE7QUFDWixlQURZLENBR1o7QUFDQTs7QUFFQSxNQUFJSyxLQUFLLEdBQUcsU0FBUkEsS0FBUSxDQUFVQyxPQUFWLEVBQW1CQyxPQUFuQixFQUE0QjtBQUN0QyxTQUFLQSxPQUFMLEdBQTJCQSxPQUEzQjtBQUNBLFNBQUtDLEtBQUwsR0FBMkJSLENBQUMsQ0FBQ1MsUUFBUSxDQUFDQyxJQUFWLENBQTVCO0FBQ0EsU0FBS0MsUUFBTCxHQUEyQlgsQ0FBQyxDQUFDTSxPQUFELENBQTVCO0FBQ0EsU0FBS00sT0FBTCxHQUEyQixLQUFLRCxRQUFMLENBQWNFLElBQWQsQ0FBbUIsZUFBbkIsQ0FBM0I7QUFDQSxTQUFLQyxTQUFMLEdBQTJCLElBQTNCO0FBQ0EsU0FBS0MsT0FBTCxHQUEyQixJQUEzQjtBQUNBLFNBQUtDLGVBQUwsR0FBMkIsSUFBM0I7QUFDQSxTQUFLQyxjQUFMLEdBQTJCLENBQTNCO0FBQ0EsU0FBS0MsbUJBQUwsR0FBMkIsS0FBM0I7O0FBRUEsUUFBSSxLQUFLWCxPQUFMLENBQWFZLE1BQWpCLEVBQXlCO0FBQ3ZCLFdBQUtSLFFBQUwsQ0FDR0UsSUFESCxDQUNRLGdCQURSLEVBRUdPLElBRkgsQ0FFUSxLQUFLYixPQUFMLENBQWFZLE1BRnJCLEVBRTZCbkIsQ0FBQyxDQUFDcUIsS0FBRixDQUFRLFlBQVk7QUFDN0MsYUFBS1YsUUFBTCxDQUFjVyxPQUFkLENBQXNCLG1CQUF0QjtBQUNELE9BRjBCLEVBRXhCLElBRndCLENBRjdCO0FBS0Q7QUFDRixHQWxCRDs7QUFvQkFqQixFQUFBQSxLQUFLLENBQUNrQixPQUFOLEdBQWlCLE9BQWpCO0FBRUFsQixFQUFBQSxLQUFLLENBQUNtQixtQkFBTixHQUE0QixHQUE1QjtBQUNBbkIsRUFBQUEsS0FBSyxDQUFDb0IsNEJBQU4sR0FBcUMsR0FBckM7QUFFQXBCLEVBQUFBLEtBQUssQ0FBQ3FCLFFBQU4sR0FBaUI7QUFDZkMsSUFBQUEsUUFBUSxFQUFFLElBREs7QUFFZkMsSUFBQUEsUUFBUSxFQUFFLElBRks7QUFHZkMsSUFBQUEsSUFBSSxFQUFFO0FBSFMsR0FBakI7O0FBTUF4QixFQUFBQSxLQUFLLENBQUN5QixTQUFOLENBQWdCQyxNQUFoQixHQUF5QixVQUFVQyxjQUFWLEVBQTBCO0FBQ2pELFdBQU8sS0FBS2pCLE9BQUwsR0FBZSxLQUFLa0IsSUFBTCxFQUFmLEdBQTZCLEtBQUtKLElBQUwsQ0FBVUcsY0FBVixDQUFwQztBQUNELEdBRkQ7O0FBSUEzQixFQUFBQSxLQUFLLENBQUN5QixTQUFOLENBQWdCRCxJQUFoQixHQUF1QixVQUFVRyxjQUFWLEVBQTBCO0FBQy9DLFFBQUlFLElBQUksR0FBRyxJQUFYO0FBQ0EsUUFBSUMsQ0FBQyxHQUFNbkMsQ0FBQyxDQUFDb0MsS0FBRixDQUFRLGlCQUFSLEVBQTJCO0FBQUVDLE1BQUFBLGFBQWEsRUFBRUw7QUFBakIsS0FBM0IsQ0FBWDtBQUVBLFNBQUtyQixRQUFMLENBQWNXLE9BQWQsQ0FBc0JhLENBQXRCO0FBRUEsUUFBSSxLQUFLcEIsT0FBTCxJQUFnQm9CLENBQUMsQ0FBQ0csa0JBQUYsRUFBcEIsRUFBNEM7QUFFNUMsU0FBS3ZCLE9BQUwsR0FBZSxJQUFmO0FBRUEsU0FBS3dCLGNBQUw7QUFDQSxTQUFLQyxZQUFMO0FBQ0EsU0FBS2hDLEtBQUwsQ0FBV2lDLFFBQVgsQ0FBb0IsWUFBcEI7QUFFQSxTQUFLQyxNQUFMO0FBQ0EsU0FBS0MsTUFBTDtBQUVBLFNBQUtoQyxRQUFMLENBQWNpQyxFQUFkLENBQWlCLDBCQUFqQixFQUE2Qyx3QkFBN0MsRUFBdUU1QyxDQUFDLENBQUNxQixLQUFGLENBQVEsS0FBS1ksSUFBYixFQUFtQixJQUFuQixDQUF2RTtBQUVBLFNBQUtyQixPQUFMLENBQWFnQyxFQUFiLENBQWdCLDhCQUFoQixFQUFnRCxZQUFZO0FBQzFEVixNQUFBQSxJQUFJLENBQUN2QixRQUFMLENBQWNrQyxHQUFkLENBQWtCLDRCQUFsQixFQUFnRCxVQUFVVixDQUFWLEVBQWE7QUFDM0QsWUFBSW5DLENBQUMsQ0FBQ21DLENBQUMsQ0FBQ1csTUFBSCxDQUFELENBQVlDLEVBQVosQ0FBZWIsSUFBSSxDQUFDdkIsUUFBcEIsQ0FBSixFQUFtQ3VCLElBQUksQ0FBQ2hCLG1CQUFMLEdBQTJCLElBQTNCO0FBQ3BDLE9BRkQ7QUFHRCxLQUpEO0FBTUEsU0FBS1MsUUFBTCxDQUFjLFlBQVk7QUFDeEIsVUFBSXFCLFVBQVUsR0FBR2hELENBQUMsQ0FBQ2lELE9BQUYsQ0FBVUQsVUFBVixJQUF3QmQsSUFBSSxDQUFDdkIsUUFBTCxDQUFjdUMsUUFBZCxDQUF1QixNQUF2QixDQUF6Qzs7QUFFQSxVQUFJLENBQUNoQixJQUFJLENBQUN2QixRQUFMLENBQWN3QyxNQUFkLEdBQXVCQyxNQUE1QixFQUFvQztBQUNsQ2xCLFFBQUFBLElBQUksQ0FBQ3ZCLFFBQUwsQ0FBYzBDLFFBQWQsQ0FBdUJuQixJQUFJLENBQUMxQixLQUE1QixFQURrQyxDQUNDO0FBQ3BDOztBQUVEMEIsTUFBQUEsSUFBSSxDQUFDdkIsUUFBTCxDQUNHa0IsSUFESCxHQUVHeUIsU0FGSCxDQUVhLENBRmI7QUFJQXBCLE1BQUFBLElBQUksQ0FBQ3FCLFlBQUw7O0FBRUEsVUFBSVAsVUFBSixFQUFnQjtBQUNkZCxRQUFBQSxJQUFJLENBQUN2QixRQUFMLENBQWMsQ0FBZCxFQUFpQjZDLFdBQWpCLENBRGMsQ0FDZTtBQUM5Qjs7QUFFRHRCLE1BQUFBLElBQUksQ0FBQ3ZCLFFBQUwsQ0FBYzhCLFFBQWQsQ0FBdUIsSUFBdkI7QUFFQVAsTUFBQUEsSUFBSSxDQUFDdUIsWUFBTDtBQUVBLFVBQUl0QixDQUFDLEdBQUduQyxDQUFDLENBQUNvQyxLQUFGLENBQVEsa0JBQVIsRUFBNEI7QUFBRUMsUUFBQUEsYUFBYSxFQUFFTDtBQUFqQixPQUE1QixDQUFSO0FBRUFnQixNQUFBQSxVQUFVLEdBQ1JkLElBQUksQ0FBQ3RCLE9BQUwsQ0FBYTtBQUFiLE9BQ0dpQyxHQURILENBQ08saUJBRFAsRUFDMEIsWUFBWTtBQUNsQ1gsUUFBQUEsSUFBSSxDQUFDdkIsUUFBTCxDQUFjVyxPQUFkLENBQXNCLE9BQXRCLEVBQStCQSxPQUEvQixDQUF1Q2EsQ0FBdkM7QUFDRCxPQUhILEVBSUd1QixvQkFKSCxDQUl3QnJELEtBQUssQ0FBQ21CLG1CQUo5QixDQURRLEdBTVJVLElBQUksQ0FBQ3ZCLFFBQUwsQ0FBY1csT0FBZCxDQUFzQixPQUF0QixFQUErQkEsT0FBL0IsQ0FBdUNhLENBQXZDLENBTkY7QUFPRCxLQTlCRDtBQStCRCxHQXhERDs7QUEwREE5QixFQUFBQSxLQUFLLENBQUN5QixTQUFOLENBQWdCRyxJQUFoQixHQUF1QixVQUFVRSxDQUFWLEVBQWE7QUFDbEMsUUFBSUEsQ0FBSixFQUFPQSxDQUFDLENBQUN3QixjQUFGO0FBRVB4QixJQUFBQSxDQUFDLEdBQUduQyxDQUFDLENBQUNvQyxLQUFGLENBQVEsaUJBQVIsQ0FBSjtBQUVBLFNBQUt6QixRQUFMLENBQWNXLE9BQWQsQ0FBc0JhLENBQXRCO0FBRUEsUUFBSSxDQUFDLEtBQUtwQixPQUFOLElBQWlCb0IsQ0FBQyxDQUFDRyxrQkFBRixFQUFyQixFQUE2QztBQUU3QyxTQUFLdkIsT0FBTCxHQUFlLEtBQWY7QUFFQSxTQUFLMkIsTUFBTDtBQUNBLFNBQUtDLE1BQUw7QUFFQTNDLElBQUFBLENBQUMsQ0FBQ1MsUUFBRCxDQUFELENBQVltRCxHQUFaLENBQWdCLG9CQUFoQjtBQUVBLFNBQUtqRCxRQUFMLENBQ0drRCxXQURILENBQ2UsSUFEZixFQUVHRCxHQUZILENBRU8sMEJBRlAsRUFHR0EsR0FISCxDQUdPLDRCQUhQO0FBS0EsU0FBS2hELE9BQUwsQ0FBYWdELEdBQWIsQ0FBaUIsOEJBQWpCO0FBRUE1RCxJQUFBQSxDQUFDLENBQUNpRCxPQUFGLENBQVVELFVBQVYsSUFBd0IsS0FBS3JDLFFBQUwsQ0FBY3VDLFFBQWQsQ0FBdUIsTUFBdkIsQ0FBeEIsR0FDRSxLQUFLdkMsUUFBTCxDQUNHa0MsR0FESCxDQUNPLGlCQURQLEVBQzBCN0MsQ0FBQyxDQUFDcUIsS0FBRixDQUFRLEtBQUt5QyxTQUFiLEVBQXdCLElBQXhCLENBRDFCLEVBRUdKLG9CQUZILENBRXdCckQsS0FBSyxDQUFDbUIsbUJBRjlCLENBREYsR0FJRSxLQUFLc0MsU0FBTCxFQUpGO0FBS0QsR0E1QkQ7O0FBOEJBekQsRUFBQUEsS0FBSyxDQUFDeUIsU0FBTixDQUFnQjJCLFlBQWhCLEdBQStCLFlBQVk7QUFDekN6RCxJQUFBQSxDQUFDLENBQUNTLFFBQUQsQ0FBRCxDQUNHbUQsR0FESCxDQUNPLG9CQURQLEVBQzZCO0FBRDdCLEtBRUdoQixFQUZILENBRU0sb0JBRk4sRUFFNEI1QyxDQUFDLENBQUNxQixLQUFGLENBQVEsVUFBVWMsQ0FBVixFQUFhO0FBQzdDLFVBQUksS0FBS3hCLFFBQUwsQ0FBYyxDQUFkLE1BQXFCd0IsQ0FBQyxDQUFDVyxNQUF2QixJQUFpQyxDQUFDLEtBQUtuQyxRQUFMLENBQWNvRCxHQUFkLENBQWtCNUIsQ0FBQyxDQUFDVyxNQUFwQixFQUE0Qk0sTUFBbEUsRUFBMEU7QUFDeEUsYUFBS3pDLFFBQUwsQ0FBY1csT0FBZCxDQUFzQixPQUF0QjtBQUNEO0FBQ0YsS0FKeUIsRUFJdkIsSUFKdUIsQ0FGNUI7QUFPRCxHQVJEOztBQVVBakIsRUFBQUEsS0FBSyxDQUFDeUIsU0FBTixDQUFnQlksTUFBaEIsR0FBeUIsWUFBWTtBQUNuQyxRQUFJLEtBQUszQixPQUFMLElBQWdCLEtBQUtSLE9BQUwsQ0FBYXFCLFFBQWpDLEVBQTJDO0FBQ3pDLFdBQUtqQixRQUFMLENBQWNpQyxFQUFkLENBQWlCLDRCQUFqQixFQUErQzVDLENBQUMsQ0FBQ3FCLEtBQUYsQ0FBUSxVQUFVYyxDQUFWLEVBQWE7QUFDbEVBLFFBQUFBLENBQUMsQ0FBQzZCLEtBQUYsSUFBVyxFQUFYLElBQWlCLEtBQUsvQixJQUFMLEVBQWpCO0FBQ0QsT0FGOEMsRUFFNUMsSUFGNEMsQ0FBL0M7QUFHRCxLQUpELE1BSU8sSUFBSSxDQUFDLEtBQUtsQixPQUFWLEVBQW1CO0FBQ3hCLFdBQUtKLFFBQUwsQ0FBY2lELEdBQWQsQ0FBa0IsNEJBQWxCO0FBQ0Q7QUFDRixHQVJEOztBQVVBdkQsRUFBQUEsS0FBSyxDQUFDeUIsU0FBTixDQUFnQmEsTUFBaEIsR0FBeUIsWUFBWTtBQUNuQyxRQUFJLEtBQUs1QixPQUFULEVBQWtCO0FBQ2hCZixNQUFBQSxDQUFDLENBQUNpRSxNQUFELENBQUQsQ0FBVXJCLEVBQVYsQ0FBYSxtQkFBYixFQUFrQzVDLENBQUMsQ0FBQ3FCLEtBQUYsQ0FBUSxLQUFLNkMsWUFBYixFQUEyQixJQUEzQixDQUFsQztBQUNELEtBRkQsTUFFTztBQUNMbEUsTUFBQUEsQ0FBQyxDQUFDaUUsTUFBRCxDQUFELENBQVVMLEdBQVYsQ0FBYyxtQkFBZDtBQUNEO0FBQ0YsR0FORDs7QUFRQXZELEVBQUFBLEtBQUssQ0FBQ3lCLFNBQU4sQ0FBZ0JnQyxTQUFoQixHQUE0QixZQUFZO0FBQ3RDLFFBQUk1QixJQUFJLEdBQUcsSUFBWDtBQUNBLFNBQUt2QixRQUFMLENBQWNzQixJQUFkO0FBQ0EsU0FBS04sUUFBTCxDQUFjLFlBQVk7QUFDeEJPLE1BQUFBLElBQUksQ0FBQzFCLEtBQUwsQ0FBV3FELFdBQVgsQ0FBdUIsWUFBdkI7QUFDQTNCLE1BQUFBLElBQUksQ0FBQ2lDLGdCQUFMO0FBQ0FqQyxNQUFBQSxJQUFJLENBQUNrQyxjQUFMO0FBQ0FsQyxNQUFBQSxJQUFJLENBQUN2QixRQUFMLENBQWNXLE9BQWQsQ0FBc0IsbUJBQXRCO0FBQ0QsS0FMRDtBQU1ELEdBVEQ7O0FBV0FqQixFQUFBQSxLQUFLLENBQUN5QixTQUFOLENBQWdCdUMsY0FBaEIsR0FBaUMsWUFBWTtBQUMzQyxTQUFLdkQsU0FBTCxJQUFrQixLQUFLQSxTQUFMLENBQWV3RCxNQUFmLEVBQWxCO0FBQ0EsU0FBS3hELFNBQUwsR0FBaUIsSUFBakI7QUFDRCxHQUhEOztBQUtBVCxFQUFBQSxLQUFLLENBQUN5QixTQUFOLENBQWdCSCxRQUFoQixHQUEyQixVQUFVNEMsUUFBVixFQUFvQjtBQUM3QyxRQUFJckMsSUFBSSxHQUFHLElBQVg7QUFDQSxRQUFJc0MsT0FBTyxHQUFHLEtBQUs3RCxRQUFMLENBQWN1QyxRQUFkLENBQXVCLE1BQXZCLElBQWlDLE1BQWpDLEdBQTBDLEVBQXhEOztBQUVBLFFBQUksS0FBS25DLE9BQUwsSUFBZ0IsS0FBS1IsT0FBTCxDQUFhb0IsUUFBakMsRUFBMkM7QUFDekMsVUFBSThDLFNBQVMsR0FBR3pFLENBQUMsQ0FBQ2lELE9BQUYsQ0FBVUQsVUFBVixJQUF3QndCLE9BQXhDO0FBRUEsV0FBSzFELFNBQUwsR0FBaUJkLENBQUMsQ0FBQ1MsUUFBUSxDQUFDaUUsYUFBVCxDQUF1QixLQUF2QixDQUFELENBQUQsQ0FDZGpDLFFBRGMsQ0FDTCxvQkFBb0IrQixPQURmLEVBRWRuQixRQUZjLENBRUwsS0FBSzdDLEtBRkEsQ0FBakI7QUFJQSxXQUFLRyxRQUFMLENBQWNpQyxFQUFkLENBQWlCLDBCQUFqQixFQUE2QzVDLENBQUMsQ0FBQ3FCLEtBQUYsQ0FBUSxVQUFVYyxDQUFWLEVBQWE7QUFDaEUsWUFBSSxLQUFLakIsbUJBQVQsRUFBOEI7QUFDNUIsZUFBS0EsbUJBQUwsR0FBMkIsS0FBM0I7QUFDQTtBQUNEOztBQUNELFlBQUlpQixDQUFDLENBQUNXLE1BQUYsS0FBYVgsQ0FBQyxDQUFDd0MsYUFBbkIsRUFBa0M7QUFDbEMsYUFBS3BFLE9BQUwsQ0FBYW9CLFFBQWIsSUFBeUIsUUFBekIsR0FDSSxLQUFLaEIsUUFBTCxDQUFjLENBQWQsRUFBaUJpRSxLQUFqQixFQURKLEdBRUksS0FBSzNDLElBQUwsRUFGSjtBQUdELE9BVDRDLEVBUzFDLElBVDBDLENBQTdDO0FBV0EsVUFBSXdDLFNBQUosRUFBZSxLQUFLM0QsU0FBTCxDQUFlLENBQWYsRUFBa0IwQyxXQUFsQixDQWxCMEIsQ0FrQkk7O0FBRTdDLFdBQUsxQyxTQUFMLENBQWUyQixRQUFmLENBQXdCLElBQXhCO0FBRUEsVUFBSSxDQUFDOEIsUUFBTCxFQUFlO0FBRWZFLE1BQUFBLFNBQVMsR0FDUCxLQUFLM0QsU0FBTCxDQUNHK0IsR0FESCxDQUNPLGlCQURQLEVBQzBCMEIsUUFEMUIsRUFFR2Isb0JBRkgsQ0FFd0JyRCxLQUFLLENBQUNvQiw0QkFGOUIsQ0FETyxHQUlQOEMsUUFBUSxFQUpWO0FBTUQsS0E5QkQsTUE4Qk8sSUFBSSxDQUFDLEtBQUt4RCxPQUFOLElBQWlCLEtBQUtELFNBQTFCLEVBQXFDO0FBQzFDLFdBQUtBLFNBQUwsQ0FBZStDLFdBQWYsQ0FBMkIsSUFBM0I7O0FBRUEsVUFBSWdCLGNBQWMsR0FBRyxTQUFqQkEsY0FBaUIsR0FBWTtBQUMvQjNDLFFBQUFBLElBQUksQ0FBQ21DLGNBQUw7QUFDQUUsUUFBQUEsUUFBUSxJQUFJQSxRQUFRLEVBQXBCO0FBQ0QsT0FIRDs7QUFJQXZFLE1BQUFBLENBQUMsQ0FBQ2lELE9BQUYsQ0FBVUQsVUFBVixJQUF3QixLQUFLckMsUUFBTCxDQUFjdUMsUUFBZCxDQUF1QixNQUF2QixDQUF4QixHQUNFLEtBQUtwQyxTQUFMLENBQ0crQixHQURILENBQ08saUJBRFAsRUFDMEJnQyxjQUQxQixFQUVHbkIsb0JBRkgsQ0FFd0JyRCxLQUFLLENBQUNvQiw0QkFGOUIsQ0FERixHQUlFb0QsY0FBYyxFQUpoQjtBQU1ELEtBYk0sTUFhQSxJQUFJTixRQUFKLEVBQWM7QUFDbkJBLE1BQUFBLFFBQVE7QUFDVDtBQUNGLEdBbERELENBN0tZLENBaU9aOzs7QUFFQWxFLEVBQUFBLEtBQUssQ0FBQ3lCLFNBQU4sQ0FBZ0JvQyxZQUFoQixHQUErQixZQUFZO0FBQ3pDLFNBQUtYLFlBQUw7QUFDRCxHQUZEOztBQUlBbEQsRUFBQUEsS0FBSyxDQUFDeUIsU0FBTixDQUFnQnlCLFlBQWhCLEdBQStCLFlBQVk7QUFDekMsUUFBSXVCLGtCQUFrQixHQUFHLEtBQUtuRSxRQUFMLENBQWMsQ0FBZCxFQUFpQm9FLFlBQWpCLEdBQWdDdEUsUUFBUSxDQUFDdUUsZUFBVCxDQUF5QkMsWUFBbEY7QUFFQSxTQUFLdEUsUUFBTCxDQUFjdUUsR0FBZCxDQUFrQjtBQUNoQkMsTUFBQUEsV0FBVyxFQUFHLENBQUMsS0FBS0MsaUJBQU4sSUFBMkJOLGtCQUEzQixHQUFnRCxLQUFLN0QsY0FBckQsR0FBc0UsRUFEcEU7QUFFaEJvRSxNQUFBQSxZQUFZLEVBQUUsS0FBS0QsaUJBQUwsSUFBMEIsQ0FBQ04sa0JBQTNCLEdBQWdELEtBQUs3RCxjQUFyRCxHQUFzRTtBQUZwRSxLQUFsQjtBQUlELEdBUEQ7O0FBU0FaLEVBQUFBLEtBQUssQ0FBQ3lCLFNBQU4sQ0FBZ0JxQyxnQkFBaEIsR0FBbUMsWUFBWTtBQUM3QyxTQUFLeEQsUUFBTCxDQUFjdUUsR0FBZCxDQUFrQjtBQUNoQkMsTUFBQUEsV0FBVyxFQUFFLEVBREc7QUFFaEJFLE1BQUFBLFlBQVksRUFBRTtBQUZFLEtBQWxCO0FBSUQsR0FMRDs7QUFPQWhGLEVBQUFBLEtBQUssQ0FBQ3lCLFNBQU4sQ0FBZ0JTLGNBQWhCLEdBQWlDLFlBQVk7QUFDM0MsUUFBSStDLGVBQWUsR0FBR3JCLE1BQU0sQ0FBQ3NCLFVBQTdCOztBQUNBLFFBQUksQ0FBQ0QsZUFBTCxFQUFzQjtBQUFFO0FBQ3RCLFVBQUlFLG1CQUFtQixHQUFHL0UsUUFBUSxDQUFDdUUsZUFBVCxDQUF5QlMscUJBQXpCLEVBQTFCO0FBQ0FILE1BQUFBLGVBQWUsR0FBR0UsbUJBQW1CLENBQUNFLEtBQXBCLEdBQTRCQyxJQUFJLENBQUNDLEdBQUwsQ0FBU0osbUJBQW1CLENBQUNLLElBQTdCLENBQTlDO0FBQ0Q7O0FBQ0QsU0FBS1QsaUJBQUwsR0FBeUIzRSxRQUFRLENBQUNDLElBQVQsQ0FBY29GLFdBQWQsR0FBNEJSLGVBQXJEO0FBQ0EsU0FBS3JFLGNBQUwsR0FBc0IsS0FBSzhFLGdCQUFMLEVBQXRCO0FBQ0QsR0FSRDs7QUFVQTFGLEVBQUFBLEtBQUssQ0FBQ3lCLFNBQU4sQ0FBZ0JVLFlBQWhCLEdBQStCLFlBQVk7QUFDekMsUUFBSXdELE9BQU8sR0FBR0MsUUFBUSxDQUFFLEtBQUt6RixLQUFMLENBQVcwRSxHQUFYLENBQWUsZUFBZixLQUFtQyxDQUFyQyxFQUF5QyxFQUF6QyxDQUF0QjtBQUNBLFNBQUtsRSxlQUFMLEdBQXVCUCxRQUFRLENBQUNDLElBQVQsQ0FBY3dGLEtBQWQsQ0FBb0JiLFlBQXBCLElBQW9DLEVBQTNEO0FBQ0EsUUFBSSxLQUFLRCxpQkFBVCxFQUE0QixLQUFLNUUsS0FBTCxDQUFXMEUsR0FBWCxDQUFlLGVBQWYsRUFBZ0NjLE9BQU8sR0FBRyxLQUFLL0UsY0FBL0M7QUFDN0IsR0FKRDs7QUFNQVosRUFBQUEsS0FBSyxDQUFDeUIsU0FBTixDQUFnQnNDLGNBQWhCLEdBQWlDLFlBQVk7QUFDM0MsU0FBSzVELEtBQUwsQ0FBVzBFLEdBQVgsQ0FBZSxlQUFmLEVBQWdDLEtBQUtsRSxlQUFyQztBQUNELEdBRkQ7O0FBSUFYLEVBQUFBLEtBQUssQ0FBQ3lCLFNBQU4sQ0FBZ0JpRSxnQkFBaEIsR0FBbUMsWUFBWTtBQUFFO0FBQy9DLFFBQUlJLFNBQVMsR0FBRzFGLFFBQVEsQ0FBQ2lFLGFBQVQsQ0FBdUIsS0FBdkIsQ0FBaEI7QUFDQXlCLElBQUFBLFNBQVMsQ0FBQ0MsU0FBVixHQUFzQix5QkFBdEI7QUFDQSxTQUFLNUYsS0FBTCxDQUFXNkYsTUFBWCxDQUFrQkYsU0FBbEI7QUFDQSxRQUFJbEYsY0FBYyxHQUFHa0YsU0FBUyxDQUFDM0MsV0FBVixHQUF3QjJDLFNBQVMsQ0FBQ0wsV0FBdkQ7QUFDQSxTQUFLdEYsS0FBTCxDQUFXLENBQVgsRUFBYzhGLFdBQWQsQ0FBMEJILFNBQTFCO0FBQ0EsV0FBT2xGLGNBQVA7QUFDRCxHQVBELENBM1FZLENBcVJaO0FBQ0E7OztBQUVBLFdBQVNzRixNQUFULENBQWdCQyxNQUFoQixFQUF3QnhFLGNBQXhCLEVBQXdDO0FBQ3RDLFdBQU8sS0FBS3lFLElBQUwsQ0FBVSxZQUFZO0FBQzNCLFVBQUlDLEtBQUssR0FBSzFHLENBQUMsQ0FBQyxJQUFELENBQWY7QUFDQSxVQUFJMkcsSUFBSSxHQUFNRCxLQUFLLENBQUNDLElBQU4sQ0FBVyxZQUFYLENBQWQ7QUFDQSxVQUFJcEcsT0FBTyxHQUFHUCxDQUFDLENBQUM0RyxNQUFGLENBQVMsRUFBVCxFQUFhdkcsS0FBSyxDQUFDcUIsUUFBbkIsRUFBNkJnRixLQUFLLENBQUNDLElBQU4sRUFBN0IsRUFBMkMsUUFBT0gsTUFBUCxLQUFpQixRQUFqQixJQUE2QkEsTUFBeEUsQ0FBZDtBQUVBLFVBQUksQ0FBQ0csSUFBTCxFQUFXRCxLQUFLLENBQUNDLElBQU4sQ0FBVyxZQUFYLEVBQTBCQSxJQUFJLEdBQUcsSUFBSXRHLEtBQUosQ0FBVSxJQUFWLEVBQWdCRSxPQUFoQixDQUFqQztBQUNYLFVBQUksT0FBT2lHLE1BQVAsSUFBaUIsUUFBckIsRUFBK0JHLElBQUksQ0FBQ0gsTUFBRCxDQUFKLENBQWF4RSxjQUFiLEVBQS9CLEtBQ0ssSUFBSXpCLE9BQU8sQ0FBQ3NCLElBQVosRUFBa0I4RSxJQUFJLENBQUM5RSxJQUFMLENBQVVHLGNBQVY7QUFDeEIsS0FSTSxDQUFQO0FBU0Q7O0FBRUQsTUFBSTZFLEdBQUcsR0FBRzdHLENBQUMsQ0FBQ0UsRUFBRixDQUFLNEcsYUFBZjtBQUVBOUcsRUFBQUEsQ0FBQyxDQUFDRSxFQUFGLENBQUs0RyxhQUFMLEdBQWlDUCxNQUFqQztBQUNBdkcsRUFBQUEsQ0FBQyxDQUFDRSxFQUFGLENBQUs0RyxhQUFMLENBQW1CQyxXQUFuQixHQUFpQzFHLEtBQWpDLENBdlNZLENBMFNaO0FBQ0E7O0FBRUFMLEVBQUFBLENBQUMsQ0FBQ0UsRUFBRixDQUFLNEcsYUFBTCxDQUFtQkUsVUFBbkIsR0FBZ0MsWUFBWTtBQUMxQ2hILElBQUFBLENBQUMsQ0FBQ0UsRUFBRixDQUFLNEcsYUFBTCxHQUFxQkQsR0FBckI7QUFDQSxXQUFPLElBQVA7QUFDRCxHQUhELENBN1NZLENBbVRaO0FBQ0E7OztBQUVBN0csRUFBQUEsQ0FBQyxDQUFDUyxRQUFELENBQUQsQ0FBWW1DLEVBQVosQ0FBZSwyQkFBZixFQUE0QywrQkFBNUMsRUFBNkUsVUFBVVQsQ0FBVixFQUFhO0FBQ3hGLFFBQUl1RSxLQUFLLEdBQUsxRyxDQUFDLENBQUMsSUFBRCxDQUFmO0FBQ0EsUUFBSWlILElBQUksR0FBTVAsS0FBSyxDQUFDUSxJQUFOLENBQVcsTUFBWCxDQUFkO0FBQ0EsUUFBSUMsT0FBTyxHQUFHbkgsQ0FBQyxDQUFDMEcsS0FBSyxDQUFDUSxJQUFOLENBQVcsYUFBWCxLQUE4QkQsSUFBSSxJQUFJQSxJQUFJLENBQUNHLE9BQUwsQ0FBYSxnQkFBYixFQUErQixFQUEvQixDQUF2QyxDQUFmLENBSHdGLENBR0c7O0FBQzNGLFFBQUlaLE1BQU0sR0FBSVcsT0FBTyxDQUFDUixJQUFSLENBQWEsWUFBYixJQUE2QixRQUE3QixHQUF3QzNHLENBQUMsQ0FBQzRHLE1BQUYsQ0FBUztBQUFFekYsTUFBQUEsTUFBTSxFQUFFLENBQUMsSUFBSWtHLElBQUosQ0FBU0osSUFBVCxDQUFELElBQW1CQTtBQUE3QixLQUFULEVBQThDRSxPQUFPLENBQUNSLElBQVIsRUFBOUMsRUFBOERELEtBQUssQ0FBQ0MsSUFBTixFQUE5RCxDQUF0RDtBQUVBLFFBQUlELEtBQUssQ0FBQzNELEVBQU4sQ0FBUyxHQUFULENBQUosRUFBbUJaLENBQUMsQ0FBQ3dCLGNBQUY7QUFFbkJ3RCxJQUFBQSxPQUFPLENBQUN0RSxHQUFSLENBQVksaUJBQVosRUFBK0IsVUFBVXlFLFNBQVYsRUFBcUI7QUFDbEQsVUFBSUEsU0FBUyxDQUFDaEYsa0JBQVYsRUFBSixFQUFvQyxPQURjLENBQ1A7O0FBQzNDNkUsTUFBQUEsT0FBTyxDQUFDdEUsR0FBUixDQUFZLG1CQUFaLEVBQWlDLFlBQVk7QUFDM0M2RCxRQUFBQSxLQUFLLENBQUMzRCxFQUFOLENBQVMsVUFBVCxLQUF3QjJELEtBQUssQ0FBQ3BGLE9BQU4sQ0FBYyxPQUFkLENBQXhCO0FBQ0QsT0FGRDtBQUdELEtBTEQ7QUFNQWlGLElBQUFBLE1BQU0sQ0FBQ2dCLElBQVAsQ0FBWUosT0FBWixFQUFxQlgsTUFBckIsRUFBNkIsSUFBN0I7QUFDRCxHQWZEO0FBaUJELENBdlVBLENBdVVDMUcsTUF2VUQsQ0FBRDtBQTBVQSxDQUFDLFVBQVVFLENBQVYsRUFBYTtBQUNaLGVBRFksQ0FHWjtBQUNBOztBQUVBLE1BQUkyQixRQUFRLEdBQUcsb0JBQWY7QUFDQSxNQUFJSSxNQUFNLEdBQUssK0JBQWY7O0FBQ0EsTUFBSXlGLFFBQVEsR0FBRyxTQUFYQSxRQUFXLENBQVVsSCxPQUFWLEVBQW1CO0FBQ2hDTixJQUFBQSxDQUFDLENBQUNNLE9BQUQsQ0FBRCxDQUFXc0MsRUFBWCxDQUFjLHFCQUFkLEVBQXFDLEtBQUtiLE1BQTFDO0FBQ0QsR0FGRDs7QUFJQXlGLEVBQUFBLFFBQVEsQ0FBQ2pHLE9BQVQsR0FBbUIsT0FBbkI7O0FBRUEsV0FBU2tHLFNBQVQsQ0FBbUJmLEtBQW5CLEVBQTBCO0FBQ3hCLFFBQUlnQixRQUFRLEdBQUdoQixLQUFLLENBQUNRLElBQU4sQ0FBVyxhQUFYLENBQWY7O0FBRUEsUUFBSSxDQUFDUSxRQUFMLEVBQWU7QUFDYkEsTUFBQUEsUUFBUSxHQUFHaEIsS0FBSyxDQUFDUSxJQUFOLENBQVcsTUFBWCxDQUFYO0FBQ0FRLE1BQUFBLFFBQVEsR0FBR0EsUUFBUSxJQUFJLFlBQVlMLElBQVosQ0FBaUJLLFFBQWpCLENBQVosSUFBMENBLFFBQVEsQ0FBQ04sT0FBVCxDQUFpQixnQkFBakIsRUFBbUMsRUFBbkMsQ0FBckQsQ0FGYSxDQUUrRTtBQUM3Rjs7QUFFRCxRQUFJTyxPQUFPLEdBQUdELFFBQVEsSUFBSTFILENBQUMsQ0FBQzBILFFBQUQsQ0FBM0I7QUFFQSxXQUFPQyxPQUFPLElBQUlBLE9BQU8sQ0FBQ3ZFLE1BQW5CLEdBQTRCdUUsT0FBNUIsR0FBc0NqQixLQUFLLENBQUN2RCxNQUFOLEVBQTdDO0FBQ0Q7O0FBRUQsV0FBU3lFLFVBQVQsQ0FBb0J6RixDQUFwQixFQUF1QjtBQUNyQixRQUFJQSxDQUFDLElBQUlBLENBQUMsQ0FBQzZCLEtBQUYsS0FBWSxDQUFyQixFQUF3QjtBQUN4QmhFLElBQUFBLENBQUMsQ0FBQzJCLFFBQUQsQ0FBRCxDQUFZMkMsTUFBWjtBQUNBdEUsSUFBQUEsQ0FBQyxDQUFDK0IsTUFBRCxDQUFELENBQVUwRSxJQUFWLENBQWUsWUFBWTtBQUN6QixVQUFJQyxLQUFLLEdBQVcxRyxDQUFDLENBQUMsSUFBRCxDQUFyQjtBQUNBLFVBQUkySCxPQUFPLEdBQVNGLFNBQVMsQ0FBQ2YsS0FBRCxDQUE3QjtBQUNBLFVBQUlyRSxhQUFhLEdBQUc7QUFBRUEsUUFBQUEsYUFBYSxFQUFFO0FBQWpCLE9BQXBCO0FBRUEsVUFBSSxDQUFDc0YsT0FBTyxDQUFDekUsUUFBUixDQUFpQixNQUFqQixDQUFMLEVBQStCO0FBRS9CLFVBQUlmLENBQUMsSUFBSUEsQ0FBQyxDQUFDMEYsSUFBRixJQUFVLE9BQWYsSUFBMEIsa0JBQWtCUixJQUFsQixDQUF1QmxGLENBQUMsQ0FBQ1csTUFBRixDQUFTZ0YsT0FBaEMsQ0FBMUIsSUFBc0U5SCxDQUFDLENBQUMrSCxRQUFGLENBQVdKLE9BQU8sQ0FBQyxDQUFELENBQWxCLEVBQXVCeEYsQ0FBQyxDQUFDVyxNQUF6QixDQUExRSxFQUE0RztBQUU1RzZFLE1BQUFBLE9BQU8sQ0FBQ3JHLE9BQVIsQ0FBZ0JhLENBQUMsR0FBR25DLENBQUMsQ0FBQ29DLEtBQUYsQ0FBUSxvQkFBUixFQUE4QkMsYUFBOUIsQ0FBcEI7QUFFQSxVQUFJRixDQUFDLENBQUNHLGtCQUFGLEVBQUosRUFBNEI7QUFFNUJvRSxNQUFBQSxLQUFLLENBQUNRLElBQU4sQ0FBVyxlQUFYLEVBQTRCLE9BQTVCO0FBQ0FTLE1BQUFBLE9BQU8sQ0FBQzlELFdBQVIsQ0FBb0IsTUFBcEIsRUFBNEJ2QyxPQUE1QixDQUFvQyxzQkFBcEMsRUFBNERlLGFBQTVEO0FBQ0QsS0FmRDtBQWdCRDs7QUFFRG1GLEVBQUFBLFFBQVEsQ0FBQzFGLFNBQVQsQ0FBbUJDLE1BQW5CLEdBQTRCLFVBQVVJLENBQVYsRUFBYTtBQUN2QyxRQUFJdUUsS0FBSyxHQUFHMUcsQ0FBQyxDQUFDLElBQUQsQ0FBYjtBQUVBLFFBQUkwRyxLQUFLLENBQUMzRCxFQUFOLENBQVMsc0JBQVQsQ0FBSixFQUFzQztBQUV0QyxRQUFJNEUsT0FBTyxHQUFJRixTQUFTLENBQUNmLEtBQUQsQ0FBeEI7QUFDQSxRQUFJc0IsUUFBUSxHQUFHTCxPQUFPLENBQUN6RSxRQUFSLENBQWlCLE1BQWpCLENBQWY7QUFFQTBFLElBQUFBLFVBQVU7O0FBRVYsUUFBSSxDQUFDSSxRQUFMLEVBQWU7QUFDYixVQUFJLGtCQUFrQnZILFFBQVEsQ0FBQ3VFLGVBQTNCLElBQThDLENBQUMyQyxPQUFPLENBQUNNLE9BQVIsQ0FBZ0IsYUFBaEIsRUFBK0I3RSxNQUFsRixFQUEwRjtBQUN4RjtBQUNBcEQsUUFBQUEsQ0FBQyxDQUFDUyxRQUFRLENBQUNpRSxhQUFULENBQXVCLEtBQXZCLENBQUQsQ0FBRCxDQUNHakMsUUFESCxDQUNZLG1CQURaLEVBRUd5RixXQUZILENBRWVsSSxDQUFDLENBQUMsSUFBRCxDQUZoQixFQUdHNEMsRUFISCxDQUdNLE9BSE4sRUFHZWdGLFVBSGY7QUFJRDs7QUFFRCxVQUFJdkYsYUFBYSxHQUFHO0FBQUVBLFFBQUFBLGFBQWEsRUFBRTtBQUFqQixPQUFwQjtBQUNBc0YsTUFBQUEsT0FBTyxDQUFDckcsT0FBUixDQUFnQmEsQ0FBQyxHQUFHbkMsQ0FBQyxDQUFDb0MsS0FBRixDQUFRLG9CQUFSLEVBQThCQyxhQUE5QixDQUFwQjtBQUVBLFVBQUlGLENBQUMsQ0FBQ0csa0JBQUYsRUFBSixFQUE0QjtBQUU1Qm9FLE1BQUFBLEtBQUssQ0FDRnBGLE9BREgsQ0FDVyxPQURYLEVBRUc0RixJQUZILENBRVEsZUFGUixFQUV5QixNQUZ6QjtBQUlBUyxNQUFBQSxPQUFPLENBQ0pRLFdBREgsQ0FDZSxNQURmLEVBRUc3RyxPQUZILENBRVcscUJBRlgsRUFFa0NlLGFBRmxDO0FBR0Q7O0FBRUQsV0FBTyxLQUFQO0FBQ0QsR0FsQ0Q7O0FBb0NBbUYsRUFBQUEsUUFBUSxDQUFDMUYsU0FBVCxDQUFtQnNHLE9BQW5CLEdBQTZCLFVBQVVqRyxDQUFWLEVBQWE7QUFDeEMsUUFBSSxDQUFDLGdCQUFnQmtGLElBQWhCLENBQXFCbEYsQ0FBQyxDQUFDNkIsS0FBdkIsQ0FBRCxJQUFrQyxrQkFBa0JxRCxJQUFsQixDQUF1QmxGLENBQUMsQ0FBQ1csTUFBRixDQUFTZ0YsT0FBaEMsQ0FBdEMsRUFBZ0Y7QUFFaEYsUUFBSXBCLEtBQUssR0FBRzFHLENBQUMsQ0FBQyxJQUFELENBQWI7QUFFQW1DLElBQUFBLENBQUMsQ0FBQ3dCLGNBQUY7QUFDQXhCLElBQUFBLENBQUMsQ0FBQ2tHLGVBQUY7QUFFQSxRQUFJM0IsS0FBSyxDQUFDM0QsRUFBTixDQUFTLHNCQUFULENBQUosRUFBc0M7QUFFdEMsUUFBSTRFLE9BQU8sR0FBSUYsU0FBUyxDQUFDZixLQUFELENBQXhCO0FBQ0EsUUFBSXNCLFFBQVEsR0FBR0wsT0FBTyxDQUFDekUsUUFBUixDQUFpQixNQUFqQixDQUFmOztBQUVBLFFBQUksQ0FBQzhFLFFBQUQsSUFBYTdGLENBQUMsQ0FBQzZCLEtBQUYsSUFBVyxFQUF4QixJQUE4QmdFLFFBQVEsSUFBSTdGLENBQUMsQ0FBQzZCLEtBQUYsSUFBVyxFQUF6RCxFQUE2RDtBQUMzRCxVQUFJN0IsQ0FBQyxDQUFDNkIsS0FBRixJQUFXLEVBQWYsRUFBbUIyRCxPQUFPLENBQUM5RyxJQUFSLENBQWFrQixNQUFiLEVBQXFCVCxPQUFyQixDQUE2QixPQUE3QjtBQUNuQixhQUFPb0YsS0FBSyxDQUFDcEYsT0FBTixDQUFjLE9BQWQsQ0FBUDtBQUNEOztBQUVELFFBQUlnSCxJQUFJLEdBQUcsOEJBQVg7QUFDQSxRQUFJQyxNQUFNLEdBQUdaLE9BQU8sQ0FBQzlHLElBQVIsQ0FBYSxtQkFBbUJ5SCxJQUFuQixHQUEwQixvQkFBMUIsR0FBaURBLElBQTlELENBQWI7QUFFQSxRQUFJLENBQUNDLE1BQU0sQ0FBQ25GLE1BQVosRUFBb0I7QUFFcEIsUUFBSW9GLEtBQUssR0FBR0QsTUFBTSxDQUFDQyxLQUFQLENBQWFyRyxDQUFDLENBQUNXLE1BQWYsQ0FBWjtBQUVBLFFBQUlYLENBQUMsQ0FBQzZCLEtBQUYsSUFBVyxFQUFYLElBQWlCd0UsS0FBSyxHQUFHLENBQTdCLEVBQWdEQSxLQUFLLEdBekJiLENBeUJ3Qjs7QUFDaEUsUUFBSXJHLENBQUMsQ0FBQzZCLEtBQUYsSUFBVyxFQUFYLElBQWlCd0UsS0FBSyxHQUFHRCxNQUFNLENBQUNuRixNQUFQLEdBQWdCLENBQTdDLEVBQWdEb0YsS0FBSyxHQTFCYixDQTBCd0I7O0FBQ2hFLFFBQUksQ0FBQyxDQUFDQSxLQUFOLEVBQWdEQSxLQUFLLEdBQUcsQ0FBUjtBQUVoREQsSUFBQUEsTUFBTSxDQUFDRSxFQUFQLENBQVVELEtBQVYsRUFBaUJsSCxPQUFqQixDQUF5QixPQUF6QjtBQUNELEdBOUJELENBcEZZLENBcUhaO0FBQ0E7OztBQUVBLFdBQVNpRixNQUFULENBQWdCQyxNQUFoQixFQUF3QjtBQUN0QixXQUFPLEtBQUtDLElBQUwsQ0FBVSxZQUFZO0FBQzNCLFVBQUlDLEtBQUssR0FBRzFHLENBQUMsQ0FBQyxJQUFELENBQWI7QUFDQSxVQUFJMkcsSUFBSSxHQUFJRCxLQUFLLENBQUNDLElBQU4sQ0FBVyxlQUFYLENBQVo7QUFFQSxVQUFJLENBQUNBLElBQUwsRUFBV0QsS0FBSyxDQUFDQyxJQUFOLENBQVcsZUFBWCxFQUE2QkEsSUFBSSxHQUFHLElBQUlhLFFBQUosQ0FBYSxJQUFiLENBQXBDO0FBQ1gsVUFBSSxPQUFPaEIsTUFBUCxJQUFpQixRQUFyQixFQUErQkcsSUFBSSxDQUFDSCxNQUFELENBQUosQ0FBYWUsSUFBYixDQUFrQmIsS0FBbEI7QUFDaEMsS0FOTSxDQUFQO0FBT0Q7O0FBRUQsTUFBSUcsR0FBRyxHQUFHN0csQ0FBQyxDQUFDRSxFQUFGLENBQUt3SSxhQUFmO0FBRUExSSxFQUFBQSxDQUFDLENBQUNFLEVBQUYsQ0FBS3dJLGFBQUwsR0FBaUNuQyxNQUFqQztBQUNBdkcsRUFBQUEsQ0FBQyxDQUFDRSxFQUFGLENBQUt3SSxhQUFMLENBQW1CM0IsV0FBbkIsR0FBaUNTLFFBQWpDLENBcklZLENBd0laO0FBQ0E7O0FBRUF4SCxFQUFBQSxDQUFDLENBQUNFLEVBQUYsQ0FBS3dJLGFBQUwsQ0FBbUIxQixVQUFuQixHQUFnQyxZQUFZO0FBQzFDaEgsSUFBQUEsQ0FBQyxDQUFDRSxFQUFGLENBQUt3SSxhQUFMLEdBQXFCN0IsR0FBckI7QUFDQSxXQUFPLElBQVA7QUFDRCxHQUhELENBM0lZLENBaUpaO0FBQ0E7OztBQUVBN0csRUFBQUEsQ0FBQyxDQUFDUyxRQUFELENBQUQsQ0FDR21DLEVBREgsQ0FDTSw4QkFETixFQUNzQ2dGLFVBRHRDLEVBRUdoRixFQUZILENBRU0sOEJBRk4sRUFFc0MsZ0JBRnRDLEVBRXdELFVBQVVULENBQVYsRUFBYTtBQUFFQSxJQUFBQSxDQUFDLENBQUNrRyxlQUFGO0FBQXFCLEdBRjVGLEVBR0d6RixFQUhILENBR00sOEJBSE4sRUFHc0NiLE1BSHRDLEVBRzhDeUYsUUFBUSxDQUFDMUYsU0FBVCxDQUFtQkMsTUFIakUsRUFJR2EsRUFKSCxDQUlNLGdDQUpOLEVBSXdDYixNQUp4QyxFQUlnRHlGLFFBQVEsQ0FBQzFGLFNBQVQsQ0FBbUJzRyxPQUpuRSxFQUtHeEYsRUFMSCxDQUtNLGdDQUxOLEVBS3dDLGdCQUx4QyxFQUswRDRFLFFBQVEsQ0FBQzFGLFNBQVQsQ0FBbUJzRyxPQUw3RSxFQU1HeEYsRUFOSCxDQU1NLGdDQU5OLEVBTXdDLG1CQU54QyxFQU02RDRFLFFBQVEsQ0FBQzFGLFNBQVQsQ0FBbUJzRyxPQU5oRjtBQVFELENBNUpBLENBNEpDdEksTUE1SkQsQ0FBRCIsInNvdXJjZXNDb250ZW50IjpbIi8qIVxyXG4gKiBHZW5lcmF0ZWQgdXNpbmcgdGhlIEJvb3RzdHJhcCBDdXN0b21pemVyIChodHRwOi8vZ2V0Ym9vdHN0cmFwLmNvbS9jdXN0b21pemUvP2lkPWY0YjRjOWNiODVkZjc1N2NhMDhjKVxyXG4gKiBDb25maWcgc2F2ZWQgdG8gY29uZmlnLmpzb24gYW5kIGh0dHBzOi8vZ2lzdC5naXRodWIuY29tL2Y0YjRjOWNiODVkZjc1N2NhMDhjXHJcbiAqL1xyXG5pZiAodHlwZW9mIGpRdWVyeSA9PT0gJ3VuZGVmaW5lZCcpIHtcclxuICB0aHJvdyBuZXcgRXJyb3IoJ0Jvb3RzdHJhcFxcJ3MgSmF2YVNjcmlwdCByZXF1aXJlcyBqUXVlcnknKVxyXG59XHJcbitmdW5jdGlvbiAoJCkge1xyXG4gICd1c2Ugc3RyaWN0JztcclxuICB2YXIgdmVyc2lvbiA9ICQuZm4uanF1ZXJ5LnNwbGl0KCcgJylbMF0uc3BsaXQoJy4nKVxyXG4gIGlmICgodmVyc2lvblswXSA8IDIgJiYgdmVyc2lvblsxXSA8IDkpIHx8ICh2ZXJzaW9uWzBdID09IDEgJiYgdmVyc2lvblsxXSA9PSA5ICYmIHZlcnNpb25bMl0gPCAxKSkge1xyXG4gICAgdGhyb3cgbmV3IEVycm9yKCdCb290c3RyYXBcXCdzIEphdmFTY3JpcHQgcmVxdWlyZXMgalF1ZXJ5IHZlcnNpb24gMS45LjEgb3IgaGlnaGVyJylcclxuICB9XHJcbn0oalF1ZXJ5KTtcclxuXHJcbi8qID09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PVxyXG4gKiBCb290c3RyYXA6IG1vZGFsLmpzIHYzLjMuNVxyXG4gKiBodHRwOi8vZ2V0Ym9vdHN0cmFwLmNvbS9qYXZhc2NyaXB0LyNtb2RhbHNcclxuICogPT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09XHJcbiAqIENvcHlyaWdodCAyMDExLTIwMTUgVHdpdHRlciwgSW5jLlxyXG4gKiBMaWNlbnNlZCB1bmRlciBNSVQgKGh0dHBzOi8vZ2l0aHViLmNvbS90d2JzL2Jvb3RzdHJhcC9ibG9iL21hc3Rlci9MSUNFTlNFKVxyXG4gKiA9PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT0gKi9cclxuXHJcblxyXG4rZnVuY3Rpb24gKCQpIHtcclxuICAndXNlIHN0cmljdCc7XHJcblxyXG4gIC8vIE1PREFMIENMQVNTIERFRklOSVRJT05cclxuICAvLyA9PT09PT09PT09PT09PT09PT09PT09XHJcblxyXG4gIHZhciBNb2RhbCA9IGZ1bmN0aW9uIChlbGVtZW50LCBvcHRpb25zKSB7XHJcbiAgICB0aGlzLm9wdGlvbnMgICAgICAgICAgICAgPSBvcHRpb25zXHJcbiAgICB0aGlzLiRib2R5ICAgICAgICAgICAgICAgPSAkKGRvY3VtZW50LmJvZHkpXHJcbiAgICB0aGlzLiRlbGVtZW50ICAgICAgICAgICAgPSAkKGVsZW1lbnQpXHJcbiAgICB0aGlzLiRkaWFsb2cgICAgICAgICAgICAgPSB0aGlzLiRlbGVtZW50LmZpbmQoJy5tb2RhbC1kaWFsb2cnKVxyXG4gICAgdGhpcy4kYmFja2Ryb3AgICAgICAgICAgID0gbnVsbFxyXG4gICAgdGhpcy5pc1Nob3duICAgICAgICAgICAgID0gbnVsbFxyXG4gICAgdGhpcy5vcmlnaW5hbEJvZHlQYWQgICAgID0gbnVsbFxyXG4gICAgdGhpcy5zY3JvbGxiYXJXaWR0aCAgICAgID0gMFxyXG4gICAgdGhpcy5pZ25vcmVCYWNrZHJvcENsaWNrID0gZmFsc2VcclxuXHJcbiAgICBpZiAodGhpcy5vcHRpb25zLnJlbW90ZSkge1xyXG4gICAgICB0aGlzLiRlbGVtZW50XHJcbiAgICAgICAgLmZpbmQoJy5tb2RhbC1jb250ZW50JylcclxuICAgICAgICAubG9hZCh0aGlzLm9wdGlvbnMucmVtb3RlLCAkLnByb3h5KGZ1bmN0aW9uICgpIHtcclxuICAgICAgICAgIHRoaXMuJGVsZW1lbnQudHJpZ2dlcignbG9hZGVkLndwYmMubW9kYWwnKVxyXG4gICAgICAgIH0sIHRoaXMpKVxyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgTW9kYWwuVkVSU0lPTiAgPSAnMy4zLjUnXHJcblxyXG4gIE1vZGFsLlRSQU5TSVRJT05fRFVSQVRJT04gPSAzMDBcclxuICBNb2RhbC5CQUNLRFJPUF9UUkFOU0lUSU9OX0RVUkFUSU9OID0gMTUwXHJcblxyXG4gIE1vZGFsLkRFRkFVTFRTID0ge1xyXG4gICAgYmFja2Ryb3A6IHRydWUsXHJcbiAgICBrZXlib2FyZDogdHJ1ZSxcclxuICAgIHNob3c6IHRydWVcclxuICB9XHJcblxyXG4gIE1vZGFsLnByb3RvdHlwZS50b2dnbGUgPSBmdW5jdGlvbiAoX3JlbGF0ZWRUYXJnZXQpIHtcclxuICAgIHJldHVybiB0aGlzLmlzU2hvd24gPyB0aGlzLmhpZGUoKSA6IHRoaXMuc2hvdyhfcmVsYXRlZFRhcmdldClcclxuICB9XHJcblxyXG4gIE1vZGFsLnByb3RvdHlwZS5zaG93ID0gZnVuY3Rpb24gKF9yZWxhdGVkVGFyZ2V0KSB7XHJcbiAgICB2YXIgdGhhdCA9IHRoaXNcclxuICAgIHZhciBlICAgID0gJC5FdmVudCgnc2hvdy53cGJjLm1vZGFsJywgeyByZWxhdGVkVGFyZ2V0OiBfcmVsYXRlZFRhcmdldCB9KVxyXG5cclxuICAgIHRoaXMuJGVsZW1lbnQudHJpZ2dlcihlKVxyXG5cclxuICAgIGlmICh0aGlzLmlzU2hvd24gfHwgZS5pc0RlZmF1bHRQcmV2ZW50ZWQoKSkgcmV0dXJuXHJcblxyXG4gICAgdGhpcy5pc1Nob3duID0gdHJ1ZVxyXG5cclxuICAgIHRoaXMuY2hlY2tTY3JvbGxiYXIoKVxyXG4gICAgdGhpcy5zZXRTY3JvbGxiYXIoKVxyXG4gICAgdGhpcy4kYm9keS5hZGRDbGFzcygnbW9kYWwtb3BlbicpXHJcblxyXG4gICAgdGhpcy5lc2NhcGUoKVxyXG4gICAgdGhpcy5yZXNpemUoKVxyXG5cclxuICAgIHRoaXMuJGVsZW1lbnQub24oJ2NsaWNrLmRpc21pc3Mud3BiYy5tb2RhbCcsICdbZGF0YS1kaXNtaXNzPVwibW9kYWxcIl0nLCAkLnByb3h5KHRoaXMuaGlkZSwgdGhpcykpXHJcblxyXG4gICAgdGhpcy4kZGlhbG9nLm9uKCdtb3VzZWRvd24uZGlzbWlzcy53cGJjLm1vZGFsJywgZnVuY3Rpb24gKCkge1xyXG4gICAgICB0aGF0LiRlbGVtZW50Lm9uZSgnbW91c2V1cC5kaXNtaXNzLndwYmMubW9kYWwnLCBmdW5jdGlvbiAoZSkge1xyXG4gICAgICAgIGlmICgkKGUudGFyZ2V0KS5pcyh0aGF0LiRlbGVtZW50KSkgdGhhdC5pZ25vcmVCYWNrZHJvcENsaWNrID0gdHJ1ZVxyXG4gICAgICB9KVxyXG4gICAgfSlcclxuXHJcbiAgICB0aGlzLmJhY2tkcm9wKGZ1bmN0aW9uICgpIHtcclxuICAgICAgdmFyIHRyYW5zaXRpb24gPSAkLnN1cHBvcnQudHJhbnNpdGlvbiAmJiB0aGF0LiRlbGVtZW50Lmhhc0NsYXNzKCdmYWRlJylcclxuXHJcbiAgICAgIGlmICghdGhhdC4kZWxlbWVudC5wYXJlbnQoKS5sZW5ndGgpIHtcclxuICAgICAgICB0aGF0LiRlbGVtZW50LmFwcGVuZFRvKHRoYXQuJGJvZHkpIC8vIGRvbid0IG1vdmUgbW9kYWxzIGRvbSBwb3NpdGlvblxyXG4gICAgICB9XHJcblxyXG4gICAgICB0aGF0LiRlbGVtZW50XHJcbiAgICAgICAgLnNob3coKVxyXG4gICAgICAgIC5zY3JvbGxUb3AoMClcclxuXHJcbiAgICAgIHRoYXQuYWRqdXN0RGlhbG9nKClcclxuXHJcbiAgICAgIGlmICh0cmFuc2l0aW9uKSB7XHJcbiAgICAgICAgdGhhdC4kZWxlbWVudFswXS5vZmZzZXRXaWR0aCAvLyBmb3JjZSByZWZsb3dcclxuICAgICAgfVxyXG5cclxuICAgICAgdGhhdC4kZWxlbWVudC5hZGRDbGFzcygnaW4nKVxyXG5cclxuICAgICAgdGhhdC5lbmZvcmNlRm9jdXMoKVxyXG5cclxuICAgICAgdmFyIGUgPSAkLkV2ZW50KCdzaG93bi53cGJjLm1vZGFsJywgeyByZWxhdGVkVGFyZ2V0OiBfcmVsYXRlZFRhcmdldCB9KVxyXG5cclxuICAgICAgdHJhbnNpdGlvbiA/XHJcbiAgICAgICAgdGhhdC4kZGlhbG9nIC8vIHdhaXQgZm9yIG1vZGFsIHRvIHNsaWRlIGluXHJcbiAgICAgICAgICAub25lKCdic1RyYW5zaXRpb25FbmQnLCBmdW5jdGlvbiAoKSB7XHJcbiAgICAgICAgICAgIHRoYXQuJGVsZW1lbnQudHJpZ2dlcignZm9jdXMnKS50cmlnZ2VyKGUpXHJcbiAgICAgICAgICB9KVxyXG4gICAgICAgICAgLmVtdWxhdGVUcmFuc2l0aW9uRW5kKE1vZGFsLlRSQU5TSVRJT05fRFVSQVRJT04pIDpcclxuICAgICAgICB0aGF0LiRlbGVtZW50LnRyaWdnZXIoJ2ZvY3VzJykudHJpZ2dlcihlKVxyXG4gICAgfSlcclxuICB9XHJcblxyXG4gIE1vZGFsLnByb3RvdHlwZS5oaWRlID0gZnVuY3Rpb24gKGUpIHtcclxuICAgIGlmIChlKSBlLnByZXZlbnREZWZhdWx0KClcclxuXHJcbiAgICBlID0gJC5FdmVudCgnaGlkZS53cGJjLm1vZGFsJylcclxuXHJcbiAgICB0aGlzLiRlbGVtZW50LnRyaWdnZXIoZSlcclxuXHJcbiAgICBpZiAoIXRoaXMuaXNTaG93biB8fCBlLmlzRGVmYXVsdFByZXZlbnRlZCgpKSByZXR1cm5cclxuXHJcbiAgICB0aGlzLmlzU2hvd24gPSBmYWxzZVxyXG5cclxuICAgIHRoaXMuZXNjYXBlKClcclxuICAgIHRoaXMucmVzaXplKClcclxuXHJcbiAgICAkKGRvY3VtZW50KS5vZmYoJ2ZvY3VzaW4ud3BiYy5tb2RhbCcpXHJcblxyXG4gICAgdGhpcy4kZWxlbWVudFxyXG4gICAgICAucmVtb3ZlQ2xhc3MoJ2luJylcclxuICAgICAgLm9mZignY2xpY2suZGlzbWlzcy53cGJjLm1vZGFsJylcclxuICAgICAgLm9mZignbW91c2V1cC5kaXNtaXNzLndwYmMubW9kYWwnKVxyXG5cclxuICAgIHRoaXMuJGRpYWxvZy5vZmYoJ21vdXNlZG93bi5kaXNtaXNzLndwYmMubW9kYWwnKVxyXG5cclxuICAgICQuc3VwcG9ydC50cmFuc2l0aW9uICYmIHRoaXMuJGVsZW1lbnQuaGFzQ2xhc3MoJ2ZhZGUnKSA/XHJcbiAgICAgIHRoaXMuJGVsZW1lbnRcclxuICAgICAgICAub25lKCdic1RyYW5zaXRpb25FbmQnLCAkLnByb3h5KHRoaXMuaGlkZU1vZGFsLCB0aGlzKSlcclxuICAgICAgICAuZW11bGF0ZVRyYW5zaXRpb25FbmQoTW9kYWwuVFJBTlNJVElPTl9EVVJBVElPTikgOlxyXG4gICAgICB0aGlzLmhpZGVNb2RhbCgpXHJcbiAgfVxyXG5cclxuICBNb2RhbC5wcm90b3R5cGUuZW5mb3JjZUZvY3VzID0gZnVuY3Rpb24gKCkge1xyXG4gICAgJChkb2N1bWVudClcclxuICAgICAgLm9mZignZm9jdXNpbi53cGJjLm1vZGFsJykgLy8gZ3VhcmQgYWdhaW5zdCBpbmZpbml0ZSBmb2N1cyBsb29wXHJcbiAgICAgIC5vbignZm9jdXNpbi53cGJjLm1vZGFsJywgJC5wcm94eShmdW5jdGlvbiAoZSkge1xyXG4gICAgICAgIGlmICh0aGlzLiRlbGVtZW50WzBdICE9PSBlLnRhcmdldCAmJiAhdGhpcy4kZWxlbWVudC5oYXMoZS50YXJnZXQpLmxlbmd0aCkge1xyXG4gICAgICAgICAgdGhpcy4kZWxlbWVudC50cmlnZ2VyKCdmb2N1cycpXHJcbiAgICAgICAgfVxyXG4gICAgICB9LCB0aGlzKSlcclxuICB9XHJcblxyXG4gIE1vZGFsLnByb3RvdHlwZS5lc2NhcGUgPSBmdW5jdGlvbiAoKSB7XHJcbiAgICBpZiAodGhpcy5pc1Nob3duICYmIHRoaXMub3B0aW9ucy5rZXlib2FyZCkge1xyXG4gICAgICB0aGlzLiRlbGVtZW50Lm9uKCdrZXlkb3duLmRpc21pc3Mud3BiYy5tb2RhbCcsICQucHJveHkoZnVuY3Rpb24gKGUpIHtcclxuICAgICAgICBlLndoaWNoID09IDI3ICYmIHRoaXMuaGlkZSgpXHJcbiAgICAgIH0sIHRoaXMpKVxyXG4gICAgfSBlbHNlIGlmICghdGhpcy5pc1Nob3duKSB7XHJcbiAgICAgIHRoaXMuJGVsZW1lbnQub2ZmKCdrZXlkb3duLmRpc21pc3Mud3BiYy5tb2RhbCcpXHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBNb2RhbC5wcm90b3R5cGUucmVzaXplID0gZnVuY3Rpb24gKCkge1xyXG4gICAgaWYgKHRoaXMuaXNTaG93bikge1xyXG4gICAgICAkKHdpbmRvdykub24oJ3Jlc2l6ZS53cGJjLm1vZGFsJywgJC5wcm94eSh0aGlzLmhhbmRsZVVwZGF0ZSwgdGhpcykpXHJcbiAgICB9IGVsc2Uge1xyXG4gICAgICAkKHdpbmRvdykub2ZmKCdyZXNpemUud3BiYy5tb2RhbCcpXHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBNb2RhbC5wcm90b3R5cGUuaGlkZU1vZGFsID0gZnVuY3Rpb24gKCkge1xyXG4gICAgdmFyIHRoYXQgPSB0aGlzXHJcbiAgICB0aGlzLiRlbGVtZW50LmhpZGUoKVxyXG4gICAgdGhpcy5iYWNrZHJvcChmdW5jdGlvbiAoKSB7XHJcbiAgICAgIHRoYXQuJGJvZHkucmVtb3ZlQ2xhc3MoJ21vZGFsLW9wZW4nKVxyXG4gICAgICB0aGF0LnJlc2V0QWRqdXN0bWVudHMoKVxyXG4gICAgICB0aGF0LnJlc2V0U2Nyb2xsYmFyKClcclxuICAgICAgdGhhdC4kZWxlbWVudC50cmlnZ2VyKCdoaWRkZW4ud3BiYy5tb2RhbCcpXHJcbiAgICB9KVxyXG4gIH1cclxuXHJcbiAgTW9kYWwucHJvdG90eXBlLnJlbW92ZUJhY2tkcm9wID0gZnVuY3Rpb24gKCkge1xyXG4gICAgdGhpcy4kYmFja2Ryb3AgJiYgdGhpcy4kYmFja2Ryb3AucmVtb3ZlKClcclxuICAgIHRoaXMuJGJhY2tkcm9wID0gbnVsbFxyXG4gIH1cclxuXHJcbiAgTW9kYWwucHJvdG90eXBlLmJhY2tkcm9wID0gZnVuY3Rpb24gKGNhbGxiYWNrKSB7XHJcbiAgICB2YXIgdGhhdCA9IHRoaXNcclxuICAgIHZhciBhbmltYXRlID0gdGhpcy4kZWxlbWVudC5oYXNDbGFzcygnZmFkZScpID8gJ2ZhZGUnIDogJydcclxuXHJcbiAgICBpZiAodGhpcy5pc1Nob3duICYmIHRoaXMub3B0aW9ucy5iYWNrZHJvcCkge1xyXG4gICAgICB2YXIgZG9BbmltYXRlID0gJC5zdXBwb3J0LnRyYW5zaXRpb24gJiYgYW5pbWF0ZVxyXG5cclxuICAgICAgdGhpcy4kYmFja2Ryb3AgPSAkKGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJ2RpdicpKVxyXG4gICAgICAgIC5hZGRDbGFzcygnbW9kYWwtYmFja2Ryb3AgJyArIGFuaW1hdGUpXHJcbiAgICAgICAgLmFwcGVuZFRvKHRoaXMuJGJvZHkpXHJcblxyXG4gICAgICB0aGlzLiRlbGVtZW50Lm9uKCdjbGljay5kaXNtaXNzLndwYmMubW9kYWwnLCAkLnByb3h5KGZ1bmN0aW9uIChlKSB7XHJcbiAgICAgICAgaWYgKHRoaXMuaWdub3JlQmFja2Ryb3BDbGljaykge1xyXG4gICAgICAgICAgdGhpcy5pZ25vcmVCYWNrZHJvcENsaWNrID0gZmFsc2VcclxuICAgICAgICAgIHJldHVyblxyXG4gICAgICAgIH1cclxuICAgICAgICBpZiAoZS50YXJnZXQgIT09IGUuY3VycmVudFRhcmdldCkgcmV0dXJuXHJcbiAgICAgICAgdGhpcy5vcHRpb25zLmJhY2tkcm9wID09ICdzdGF0aWMnXHJcbiAgICAgICAgICA/IHRoaXMuJGVsZW1lbnRbMF0uZm9jdXMoKVxyXG4gICAgICAgICAgOiB0aGlzLmhpZGUoKVxyXG4gICAgICB9LCB0aGlzKSlcclxuXHJcbiAgICAgIGlmIChkb0FuaW1hdGUpIHRoaXMuJGJhY2tkcm9wWzBdLm9mZnNldFdpZHRoIC8vIGZvcmNlIHJlZmxvd1xyXG5cclxuICAgICAgdGhpcy4kYmFja2Ryb3AuYWRkQ2xhc3MoJ2luJylcclxuXHJcbiAgICAgIGlmICghY2FsbGJhY2spIHJldHVyblxyXG5cclxuICAgICAgZG9BbmltYXRlID9cclxuICAgICAgICB0aGlzLiRiYWNrZHJvcFxyXG4gICAgICAgICAgLm9uZSgnYnNUcmFuc2l0aW9uRW5kJywgY2FsbGJhY2spXHJcbiAgICAgICAgICAuZW11bGF0ZVRyYW5zaXRpb25FbmQoTW9kYWwuQkFDS0RST1BfVFJBTlNJVElPTl9EVVJBVElPTikgOlxyXG4gICAgICAgIGNhbGxiYWNrKClcclxuXHJcbiAgICB9IGVsc2UgaWYgKCF0aGlzLmlzU2hvd24gJiYgdGhpcy4kYmFja2Ryb3ApIHtcclxuICAgICAgdGhpcy4kYmFja2Ryb3AucmVtb3ZlQ2xhc3MoJ2luJylcclxuXHJcbiAgICAgIHZhciBjYWxsYmFja1JlbW92ZSA9IGZ1bmN0aW9uICgpIHtcclxuICAgICAgICB0aGF0LnJlbW92ZUJhY2tkcm9wKClcclxuICAgICAgICBjYWxsYmFjayAmJiBjYWxsYmFjaygpXHJcbiAgICAgIH1cclxuICAgICAgJC5zdXBwb3J0LnRyYW5zaXRpb24gJiYgdGhpcy4kZWxlbWVudC5oYXNDbGFzcygnZmFkZScpID9cclxuICAgICAgICB0aGlzLiRiYWNrZHJvcFxyXG4gICAgICAgICAgLm9uZSgnYnNUcmFuc2l0aW9uRW5kJywgY2FsbGJhY2tSZW1vdmUpXHJcbiAgICAgICAgICAuZW11bGF0ZVRyYW5zaXRpb25FbmQoTW9kYWwuQkFDS0RST1BfVFJBTlNJVElPTl9EVVJBVElPTikgOlxyXG4gICAgICAgIGNhbGxiYWNrUmVtb3ZlKClcclxuXHJcbiAgICB9IGVsc2UgaWYgKGNhbGxiYWNrKSB7XHJcbiAgICAgIGNhbGxiYWNrKClcclxuICAgIH1cclxuICB9XHJcblxyXG4gIC8vIHRoZXNlIGZvbGxvd2luZyBtZXRob2RzIGFyZSB1c2VkIHRvIGhhbmRsZSBvdmVyZmxvd2luZyBtb2RhbHNcclxuXHJcbiAgTW9kYWwucHJvdG90eXBlLmhhbmRsZVVwZGF0ZSA9IGZ1bmN0aW9uICgpIHtcclxuICAgIHRoaXMuYWRqdXN0RGlhbG9nKClcclxuICB9XHJcblxyXG4gIE1vZGFsLnByb3RvdHlwZS5hZGp1c3REaWFsb2cgPSBmdW5jdGlvbiAoKSB7XHJcbiAgICB2YXIgbW9kYWxJc092ZXJmbG93aW5nID0gdGhpcy4kZWxlbWVudFswXS5zY3JvbGxIZWlnaHQgPiBkb2N1bWVudC5kb2N1bWVudEVsZW1lbnQuY2xpZW50SGVpZ2h0XHJcblxyXG4gICAgdGhpcy4kZWxlbWVudC5jc3Moe1xyXG4gICAgICBwYWRkaW5nTGVmdDogICF0aGlzLmJvZHlJc092ZXJmbG93aW5nICYmIG1vZGFsSXNPdmVyZmxvd2luZyA/IHRoaXMuc2Nyb2xsYmFyV2lkdGggOiAnJyxcclxuICAgICAgcGFkZGluZ1JpZ2h0OiB0aGlzLmJvZHlJc092ZXJmbG93aW5nICYmICFtb2RhbElzT3ZlcmZsb3dpbmcgPyB0aGlzLnNjcm9sbGJhcldpZHRoIDogJydcclxuICAgIH0pXHJcbiAgfVxyXG5cclxuICBNb2RhbC5wcm90b3R5cGUucmVzZXRBZGp1c3RtZW50cyA9IGZ1bmN0aW9uICgpIHtcclxuICAgIHRoaXMuJGVsZW1lbnQuY3NzKHtcclxuICAgICAgcGFkZGluZ0xlZnQ6ICcnLFxyXG4gICAgICBwYWRkaW5nUmlnaHQ6ICcnXHJcbiAgICB9KVxyXG4gIH1cclxuXHJcbiAgTW9kYWwucHJvdG90eXBlLmNoZWNrU2Nyb2xsYmFyID0gZnVuY3Rpb24gKCkge1xyXG4gICAgdmFyIGZ1bGxXaW5kb3dXaWR0aCA9IHdpbmRvdy5pbm5lcldpZHRoXHJcbiAgICBpZiAoIWZ1bGxXaW5kb3dXaWR0aCkgeyAvLyB3b3JrYXJvdW5kIGZvciBtaXNzaW5nIHdpbmRvdy5pbm5lcldpZHRoIGluIElFOFxyXG4gICAgICB2YXIgZG9jdW1lbnRFbGVtZW50UmVjdCA9IGRvY3VtZW50LmRvY3VtZW50RWxlbWVudC5nZXRCb3VuZGluZ0NsaWVudFJlY3QoKVxyXG4gICAgICBmdWxsV2luZG93V2lkdGggPSBkb2N1bWVudEVsZW1lbnRSZWN0LnJpZ2h0IC0gTWF0aC5hYnMoZG9jdW1lbnRFbGVtZW50UmVjdC5sZWZ0KVxyXG4gICAgfVxyXG4gICAgdGhpcy5ib2R5SXNPdmVyZmxvd2luZyA9IGRvY3VtZW50LmJvZHkuY2xpZW50V2lkdGggPCBmdWxsV2luZG93V2lkdGhcclxuICAgIHRoaXMuc2Nyb2xsYmFyV2lkdGggPSB0aGlzLm1lYXN1cmVTY3JvbGxiYXIoKVxyXG4gIH1cclxuXHJcbiAgTW9kYWwucHJvdG90eXBlLnNldFNjcm9sbGJhciA9IGZ1bmN0aW9uICgpIHtcclxuICAgIHZhciBib2R5UGFkID0gcGFyc2VJbnQoKHRoaXMuJGJvZHkuY3NzKCdwYWRkaW5nLXJpZ2h0JykgfHwgMCksIDEwKVxyXG4gICAgdGhpcy5vcmlnaW5hbEJvZHlQYWQgPSBkb2N1bWVudC5ib2R5LnN0eWxlLnBhZGRpbmdSaWdodCB8fCAnJ1xyXG4gICAgaWYgKHRoaXMuYm9keUlzT3ZlcmZsb3dpbmcpIHRoaXMuJGJvZHkuY3NzKCdwYWRkaW5nLXJpZ2h0JywgYm9keVBhZCArIHRoaXMuc2Nyb2xsYmFyV2lkdGgpXHJcbiAgfVxyXG5cclxuICBNb2RhbC5wcm90b3R5cGUucmVzZXRTY3JvbGxiYXIgPSBmdW5jdGlvbiAoKSB7XHJcbiAgICB0aGlzLiRib2R5LmNzcygncGFkZGluZy1yaWdodCcsIHRoaXMub3JpZ2luYWxCb2R5UGFkKVxyXG4gIH1cclxuXHJcbiAgTW9kYWwucHJvdG90eXBlLm1lYXN1cmVTY3JvbGxiYXIgPSBmdW5jdGlvbiAoKSB7IC8vIHRoeCB3YWxzaFxyXG4gICAgdmFyIHNjcm9sbERpdiA9IGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJ2RpdicpXHJcbiAgICBzY3JvbGxEaXYuY2xhc3NOYW1lID0gJ21vZGFsLXNjcm9sbGJhci1tZWFzdXJlJ1xyXG4gICAgdGhpcy4kYm9keS5hcHBlbmQoc2Nyb2xsRGl2KVxyXG4gICAgdmFyIHNjcm9sbGJhcldpZHRoID0gc2Nyb2xsRGl2Lm9mZnNldFdpZHRoIC0gc2Nyb2xsRGl2LmNsaWVudFdpZHRoXHJcbiAgICB0aGlzLiRib2R5WzBdLnJlbW92ZUNoaWxkKHNjcm9sbERpdilcclxuICAgIHJldHVybiBzY3JvbGxiYXJXaWR0aFxyXG4gIH1cclxuXHJcblxyXG4gIC8vIE1PREFMIFBMVUdJTiBERUZJTklUSU9OXHJcbiAgLy8gPT09PT09PT09PT09PT09PT09PT09PT1cclxuXHJcbiAgZnVuY3Rpb24gUGx1Z2luKG9wdGlvbiwgX3JlbGF0ZWRUYXJnZXQpIHtcclxuICAgIHJldHVybiB0aGlzLmVhY2goZnVuY3Rpb24gKCkge1xyXG4gICAgICB2YXIgJHRoaXMgICA9ICQodGhpcylcclxuICAgICAgdmFyIGRhdGEgICAgPSAkdGhpcy5kYXRhKCd3cGJjLm1vZGFsJylcclxuICAgICAgdmFyIG9wdGlvbnMgPSAkLmV4dGVuZCh7fSwgTW9kYWwuREVGQVVMVFMsICR0aGlzLmRhdGEoKSwgdHlwZW9mIG9wdGlvbiA9PSAnb2JqZWN0JyAmJiBvcHRpb24pXHJcblxyXG4gICAgICBpZiAoIWRhdGEpICR0aGlzLmRhdGEoJ3dwYmMubW9kYWwnLCAoZGF0YSA9IG5ldyBNb2RhbCh0aGlzLCBvcHRpb25zKSkpXHJcbiAgICAgIGlmICh0eXBlb2Ygb3B0aW9uID09ICdzdHJpbmcnKSBkYXRhW29wdGlvbl0oX3JlbGF0ZWRUYXJnZXQpXHJcbiAgICAgIGVsc2UgaWYgKG9wdGlvbnMuc2hvdykgZGF0YS5zaG93KF9yZWxhdGVkVGFyZ2V0KVxyXG4gICAgfSlcclxuICB9XHJcblxyXG4gIHZhciBvbGQgPSAkLmZuLndwYmNfbXlfbW9kYWxcclxuXHJcbiAgJC5mbi53cGJjX215X21vZGFsICAgICAgICAgICAgID0gUGx1Z2luXHJcbiAgJC5mbi53cGJjX215X21vZGFsLkNvbnN0cnVjdG9yID0gTW9kYWxcclxuXHJcblxyXG4gIC8vIE1PREFMIE5PIENPTkZMSUNUXHJcbiAgLy8gPT09PT09PT09PT09PT09PT1cclxuXHJcbiAgJC5mbi53cGJjX215X21vZGFsLm5vQ29uZmxpY3QgPSBmdW5jdGlvbiAoKSB7XHJcbiAgICAkLmZuLndwYmNfbXlfbW9kYWwgPSBvbGRcclxuICAgIHJldHVybiB0aGlzXHJcbiAgfVxyXG5cclxuXHJcbiAgLy8gTU9EQUwgREFUQS1BUElcclxuICAvLyA9PT09PT09PT09PT09PVxyXG5cclxuICAkKGRvY3VtZW50KS5vbignY2xpY2sud3BiYy5tb2RhbC5kYXRhLWFwaScsICdbZGF0YS10b2dnbGU9XCJ3cGJjX215X21vZGFsXCJdJywgZnVuY3Rpb24gKGUpIHtcclxuICAgIHZhciAkdGhpcyAgID0gJCh0aGlzKVxyXG4gICAgdmFyIGhyZWYgICAgPSAkdGhpcy5hdHRyKCdocmVmJylcclxuICAgIHZhciAkdGFyZ2V0ID0gJCgkdGhpcy5hdHRyKCdkYXRhLXRhcmdldCcpIHx8IChocmVmICYmIGhyZWYucmVwbGFjZSgvLiooPz0jW15cXHNdKyQpLywgJycpKSkgLy8gc3RyaXAgZm9yIGllN1xyXG4gICAgdmFyIG9wdGlvbiAgPSAkdGFyZ2V0LmRhdGEoJ3dwYmMubW9kYWwnKSA/ICd0b2dnbGUnIDogJC5leHRlbmQoeyByZW1vdGU6ICEvIy8udGVzdChocmVmKSAmJiBocmVmIH0sICR0YXJnZXQuZGF0YSgpLCAkdGhpcy5kYXRhKCkpXHJcblxyXG4gICAgaWYgKCR0aGlzLmlzKCdhJykpIGUucHJldmVudERlZmF1bHQoKVxyXG5cclxuICAgICR0YXJnZXQub25lKCdzaG93LndwYmMubW9kYWwnLCBmdW5jdGlvbiAoc2hvd0V2ZW50KSB7XHJcbiAgICAgIGlmIChzaG93RXZlbnQuaXNEZWZhdWx0UHJldmVudGVkKCkpIHJldHVybiAvLyBvbmx5IHJlZ2lzdGVyIGZvY3VzIHJlc3RvcmVyIGlmIG1vZGFsIHdpbGwgYWN0dWFsbHkgZ2V0IHNob3duXHJcbiAgICAgICR0YXJnZXQub25lKCdoaWRkZW4ud3BiYy5tb2RhbCcsIGZ1bmN0aW9uICgpIHtcclxuICAgICAgICAkdGhpcy5pcygnOnZpc2libGUnKSAmJiAkdGhpcy50cmlnZ2VyKCdmb2N1cycpXHJcbiAgICAgIH0pXHJcbiAgICB9KVxyXG4gICAgUGx1Z2luLmNhbGwoJHRhcmdldCwgb3B0aW9uLCB0aGlzKVxyXG4gIH0pXHJcblxyXG59KGpRdWVyeSk7XHJcblxyXG5cclxuK2Z1bmN0aW9uICgkKSB7XHJcbiAgJ3VzZSBzdHJpY3QnO1xyXG5cclxuICAvLyBEUk9QRE9XTiBDTEFTUyBERUZJTklUSU9OXHJcbiAgLy8gPT09PT09PT09PT09PT09PT09PT09PT09PVxyXG5cclxuICB2YXIgYmFja2Ryb3AgPSAnLmRyb3Bkb3duLWJhY2tkcm9wJ1xyXG4gIHZhciB0b2dnbGUgICA9ICdbZGF0YS10b2dnbGU9XCJ3cGJjX2Ryb3Bkb3duXCJdJ1xyXG4gIHZhciBEcm9wZG93biA9IGZ1bmN0aW9uIChlbGVtZW50KSB7XHJcbiAgICAkKGVsZW1lbnQpLm9uKCdjbGljay53cGJjLmRyb3Bkb3duJywgdGhpcy50b2dnbGUpXHJcbiAgfVxyXG5cclxuICBEcm9wZG93bi5WRVJTSU9OID0gJzMuMy41J1xyXG5cclxuICBmdW5jdGlvbiBnZXRQYXJlbnQoJHRoaXMpIHtcclxuICAgIHZhciBzZWxlY3RvciA9ICR0aGlzLmF0dHIoJ2RhdGEtdGFyZ2V0JylcclxuXHJcbiAgICBpZiAoIXNlbGVjdG9yKSB7XHJcbiAgICAgIHNlbGVjdG9yID0gJHRoaXMuYXR0cignaHJlZicpXHJcbiAgICAgIHNlbGVjdG9yID0gc2VsZWN0b3IgJiYgLyNbQS1aYS16XS8udGVzdChzZWxlY3RvcikgJiYgc2VsZWN0b3IucmVwbGFjZSgvLiooPz0jW15cXHNdKiQpLywgJycpIC8vIHN0cmlwIGZvciBpZTdcclxuICAgIH1cclxuXHJcbiAgICB2YXIgJHBhcmVudCA9IHNlbGVjdG9yICYmICQoc2VsZWN0b3IpXHJcblxyXG4gICAgcmV0dXJuICRwYXJlbnQgJiYgJHBhcmVudC5sZW5ndGggPyAkcGFyZW50IDogJHRoaXMucGFyZW50KClcclxuICB9XHJcblxyXG4gIGZ1bmN0aW9uIGNsZWFyTWVudXMoZSkge1xyXG4gICAgaWYgKGUgJiYgZS53aGljaCA9PT0gMykgcmV0dXJuXHJcbiAgICAkKGJhY2tkcm9wKS5yZW1vdmUoKVxyXG4gICAgJCh0b2dnbGUpLmVhY2goZnVuY3Rpb24gKCkge1xyXG4gICAgICB2YXIgJHRoaXMgICAgICAgICA9ICQodGhpcylcclxuICAgICAgdmFyICRwYXJlbnQgICAgICAgPSBnZXRQYXJlbnQoJHRoaXMpXHJcbiAgICAgIHZhciByZWxhdGVkVGFyZ2V0ID0geyByZWxhdGVkVGFyZ2V0OiB0aGlzIH1cclxuXHJcbiAgICAgIGlmICghJHBhcmVudC5oYXNDbGFzcygnb3BlbicpKSByZXR1cm5cclxuXHJcbiAgICAgIGlmIChlICYmIGUudHlwZSA9PSAnY2xpY2snICYmIC9pbnB1dHx0ZXh0YXJlYS9pLnRlc3QoZS50YXJnZXQudGFnTmFtZSkgJiYgJC5jb250YWlucygkcGFyZW50WzBdLCBlLnRhcmdldCkpIHJldHVyblxyXG5cclxuICAgICAgJHBhcmVudC50cmlnZ2VyKGUgPSAkLkV2ZW50KCdoaWRlLndwYmMuZHJvcGRvd24nLCByZWxhdGVkVGFyZ2V0KSlcclxuXHJcbiAgICAgIGlmIChlLmlzRGVmYXVsdFByZXZlbnRlZCgpKSByZXR1cm5cclxuXHJcbiAgICAgICR0aGlzLmF0dHIoJ2FyaWEtZXhwYW5kZWQnLCAnZmFsc2UnKVxyXG4gICAgICAkcGFyZW50LnJlbW92ZUNsYXNzKCdvcGVuJykudHJpZ2dlcignaGlkZGVuLndwYmMuZHJvcGRvd24nLCByZWxhdGVkVGFyZ2V0KVxyXG4gICAgfSlcclxuICB9XHJcblxyXG4gIERyb3Bkb3duLnByb3RvdHlwZS50b2dnbGUgPSBmdW5jdGlvbiAoZSkge1xyXG4gICAgdmFyICR0aGlzID0gJCh0aGlzKVxyXG5cclxuICAgIGlmICgkdGhpcy5pcygnLmRpc2FibGVkLCA6ZGlzYWJsZWQnKSkgcmV0dXJuXHJcblxyXG4gICAgdmFyICRwYXJlbnQgID0gZ2V0UGFyZW50KCR0aGlzKVxyXG4gICAgdmFyIGlzQWN0aXZlID0gJHBhcmVudC5oYXNDbGFzcygnb3BlbicpXHJcblxyXG4gICAgY2xlYXJNZW51cygpXHJcblxyXG4gICAgaWYgKCFpc0FjdGl2ZSkge1xyXG4gICAgICBpZiAoJ29udG91Y2hzdGFydCcgaW4gZG9jdW1lbnQuZG9jdW1lbnRFbGVtZW50ICYmICEkcGFyZW50LmNsb3Nlc3QoJy5uYXZiYXItbmF2JykubGVuZ3RoKSB7XHJcbiAgICAgICAgLy8gaWYgbW9iaWxlIHdlIHVzZSBhIGJhY2tkcm9wIGJlY2F1c2UgY2xpY2sgZXZlbnRzIGRvbid0IGRlbGVnYXRlXHJcbiAgICAgICAgJChkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcclxuICAgICAgICAgIC5hZGRDbGFzcygnZHJvcGRvd24tYmFja2Ryb3AnKVxyXG4gICAgICAgICAgLmluc2VydEFmdGVyKCQodGhpcykpXHJcbiAgICAgICAgICAub24oJ2NsaWNrJywgY2xlYXJNZW51cylcclxuICAgICAgfVxyXG5cclxuICAgICAgdmFyIHJlbGF0ZWRUYXJnZXQgPSB7IHJlbGF0ZWRUYXJnZXQ6IHRoaXMgfVxyXG4gICAgICAkcGFyZW50LnRyaWdnZXIoZSA9ICQuRXZlbnQoJ3Nob3cud3BiYy5kcm9wZG93bicsIHJlbGF0ZWRUYXJnZXQpKVxyXG5cclxuICAgICAgaWYgKGUuaXNEZWZhdWx0UHJldmVudGVkKCkpIHJldHVyblxyXG5cclxuICAgICAgJHRoaXNcclxuICAgICAgICAudHJpZ2dlcignZm9jdXMnKVxyXG4gICAgICAgIC5hdHRyKCdhcmlhLWV4cGFuZGVkJywgJ3RydWUnKVxyXG5cclxuICAgICAgJHBhcmVudFxyXG4gICAgICAgIC50b2dnbGVDbGFzcygnb3BlbicpXHJcbiAgICAgICAgLnRyaWdnZXIoJ3Nob3duLndwYmMuZHJvcGRvd24nLCByZWxhdGVkVGFyZ2V0KVxyXG4gICAgfVxyXG5cclxuICAgIHJldHVybiBmYWxzZVxyXG4gIH1cclxuXHJcbiAgRHJvcGRvd24ucHJvdG90eXBlLmtleWRvd24gPSBmdW5jdGlvbiAoZSkge1xyXG4gICAgaWYgKCEvKDM4fDQwfDI3fDMyKS8udGVzdChlLndoaWNoKSB8fCAvaW5wdXR8dGV4dGFyZWEvaS50ZXN0KGUudGFyZ2V0LnRhZ05hbWUpKSByZXR1cm5cclxuXHJcbiAgICB2YXIgJHRoaXMgPSAkKHRoaXMpXHJcblxyXG4gICAgZS5wcmV2ZW50RGVmYXVsdCgpXHJcbiAgICBlLnN0b3BQcm9wYWdhdGlvbigpXHJcblxyXG4gICAgaWYgKCR0aGlzLmlzKCcuZGlzYWJsZWQsIDpkaXNhYmxlZCcpKSByZXR1cm5cclxuXHJcbiAgICB2YXIgJHBhcmVudCAgPSBnZXRQYXJlbnQoJHRoaXMpXHJcbiAgICB2YXIgaXNBY3RpdmUgPSAkcGFyZW50Lmhhc0NsYXNzKCdvcGVuJylcclxuXHJcbiAgICBpZiAoIWlzQWN0aXZlICYmIGUud2hpY2ggIT0gMjcgfHwgaXNBY3RpdmUgJiYgZS53aGljaCA9PSAyNykge1xyXG4gICAgICBpZiAoZS53aGljaCA9PSAyNykgJHBhcmVudC5maW5kKHRvZ2dsZSkudHJpZ2dlcignZm9jdXMnKVxyXG4gICAgICByZXR1cm4gJHRoaXMudHJpZ2dlcignY2xpY2snKVxyXG4gICAgfVxyXG5cclxuICAgIHZhciBkZXNjID0gJyBsaTpub3QoLmRpc2FibGVkKTp2aXNpYmxlIGEnXHJcbiAgICB2YXIgJGl0ZW1zID0gJHBhcmVudC5maW5kKCcuZHJvcGRvd24tbWVudScgKyBkZXNjICsgJywudWlfZHJvcGRvd25fbWVudScgKyBkZXNjKVxyXG5cclxuICAgIGlmICghJGl0ZW1zLmxlbmd0aCkgcmV0dXJuXHJcblxyXG4gICAgdmFyIGluZGV4ID0gJGl0ZW1zLmluZGV4KGUudGFyZ2V0KVxyXG5cclxuICAgIGlmIChlLndoaWNoID09IDM4ICYmIGluZGV4ID4gMCkgICAgICAgICAgICAgICAgIGluZGV4LS0gICAgICAgICAvLyB1cFxyXG4gICAgaWYgKGUud2hpY2ggPT0gNDAgJiYgaW5kZXggPCAkaXRlbXMubGVuZ3RoIC0gMSkgaW5kZXgrKyAgICAgICAgIC8vIGRvd25cclxuICAgIGlmICghfmluZGV4KSAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGluZGV4ID0gMFxyXG5cclxuICAgICRpdGVtcy5lcShpbmRleCkudHJpZ2dlcignZm9jdXMnKVxyXG4gIH1cclxuXHJcblxyXG4gIC8vIERST1BET1dOIFBMVUdJTiBERUZJTklUSU9OXHJcbiAgLy8gPT09PT09PT09PT09PT09PT09PT09PT09PT1cclxuXHJcbiAgZnVuY3Rpb24gUGx1Z2luKG9wdGlvbikge1xyXG4gICAgcmV0dXJuIHRoaXMuZWFjaChmdW5jdGlvbiAoKSB7XHJcbiAgICAgIHZhciAkdGhpcyA9ICQodGhpcylcclxuICAgICAgdmFyIGRhdGEgID0gJHRoaXMuZGF0YSgnd3BiYy5kcm9wZG93bicpXHJcblxyXG4gICAgICBpZiAoIWRhdGEpICR0aGlzLmRhdGEoJ3dwYmMuZHJvcGRvd24nLCAoZGF0YSA9IG5ldyBEcm9wZG93bih0aGlzKSkpXHJcbiAgICAgIGlmICh0eXBlb2Ygb3B0aW9uID09ICdzdHJpbmcnKSBkYXRhW29wdGlvbl0uY2FsbCgkdGhpcylcclxuICAgIH0pXHJcbiAgfVxyXG5cclxuICB2YXIgb2xkID0gJC5mbi53cGJjX2Ryb3Bkb3duXHJcblxyXG4gICQuZm4ud3BiY19kcm9wZG93biAgICAgICAgICAgICA9IFBsdWdpblxyXG4gICQuZm4ud3BiY19kcm9wZG93bi5Db25zdHJ1Y3RvciA9IERyb3Bkb3duXHJcblxyXG5cclxuICAvLyBEUk9QRE9XTiBOTyBDT05GTElDVFxyXG4gIC8vID09PT09PT09PT09PT09PT09PT09XHJcblxyXG4gICQuZm4ud3BiY19kcm9wZG93bi5ub0NvbmZsaWN0ID0gZnVuY3Rpb24gKCkge1xyXG4gICAgJC5mbi53cGJjX2Ryb3Bkb3duID0gb2xkXHJcbiAgICByZXR1cm4gdGhpc1xyXG4gIH1cclxuXHJcblxyXG4gIC8vIEFQUExZIFRPIFNUQU5EQVJEIERST1BET1dOIEVMRU1FTlRTXHJcbiAgLy8gPT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT1cclxuXHJcbiAgJChkb2N1bWVudClcclxuICAgIC5vbignY2xpY2sud3BiYy5kcm9wZG93bi5kYXRhLWFwaScsIGNsZWFyTWVudXMpXHJcbiAgICAub24oJ2NsaWNrLndwYmMuZHJvcGRvd24uZGF0YS1hcGknLCAnLmRyb3Bkb3duIGZvcm0nLCBmdW5jdGlvbiAoZSkgeyBlLnN0b3BQcm9wYWdhdGlvbigpIH0pXHJcbiAgICAub24oJ2NsaWNrLndwYmMuZHJvcGRvd24uZGF0YS1hcGknLCB0b2dnbGUsIERyb3Bkb3duLnByb3RvdHlwZS50b2dnbGUpXHJcbiAgICAub24oJ2tleWRvd24ud3BiYy5kcm9wZG93bi5kYXRhLWFwaScsIHRvZ2dsZSwgRHJvcGRvd24ucHJvdG90eXBlLmtleWRvd24pXHJcbiAgICAub24oJ2tleWRvd24ud3BiYy5kcm9wZG93bi5kYXRhLWFwaScsICcuZHJvcGRvd24tbWVudScsIERyb3Bkb3duLnByb3RvdHlwZS5rZXlkb3duKVxyXG4gICAgLm9uKCdrZXlkb3duLndwYmMuZHJvcGRvd24uZGF0YS1hcGknLCAnLnVpX2Ryb3Bkb3duX21lbnUnLCBEcm9wZG93bi5wcm90b3R5cGUua2V5ZG93bilcclxuXHJcbn0oalF1ZXJ5KTtcclxuIl0sImZpbGUiOiJhc3NldHMvbGlicy91aS9fb3V0L2Ryb3Bkb3duX21vZGFsLmpzIn0=
