"use strict";

/**
 * Shortcode Config - Main Loop
 */
function wpbc_set_shortcode() {
  if (0 === jQuery('#wpbc_shortcode_type').length) {
    console.log('WPBC :: Error! Element #wpbc_shortcode_type not exist!');
    return;
  }
  var wpbc_shortcode = '[';
  var shortcode_id = jQuery('#wpbc_shortcode_type').val().trim();

  // -----------------------------------------------------------------------------------------------------------------
  // [booking]  | [bookingcalendar] | ...
  // -----------------------------------------------------------------------------------------------------

  if ('booking' === shortcode_id || 'bookingcalendar' === shortcode_id || 'bookingselect' === shortcode_id || 'bookingtimeline' === shortcode_id || 'bookingform' === shortcode_id || 'bookingsearch' === shortcode_id || 'bookingother' === shortcode_id || 'booking_import_ics' === shortcode_id || 'booking_listing_ics' === shortcode_id) {
    wpbc_shortcode += shortcode_id;
    var wpbc_options_arr = [];

    // -------------------------------------------------------------------------------------------------------------
    // [bookingselect] | [bookingtimeline] - Options relative only to this shortcode.
    // -------------------------------------------------------------------------------------------------------------
    if ('bookingselect' === shortcode_id || 'bookingtimeline' === shortcode_id) {
      // [bookingselect type='1,2,3'] - Multiple Resources
      if (jQuery('#' + shortcode_id + '_wpbc_multiple_resources').length > 0) {
        var multiple_resources = jQuery('#' + shortcode_id + '_wpbc_multiple_resources').val();
        if (multiple_resources != null && multiple_resources.length > 0) {
          // Remove empty spaces from  array : '' | "" | 0
          multiple_resources = multiple_resources.filter(function (n) {
            return parseInt(n);
          });
          multiple_resources = multiple_resources.join(',').trim();
          if (multiple_resources != 0) {
            wpbc_shortcode += ' type=\'' + multiple_resources + '\'';
          }
        }
      }

      // [bookingselect selected_type=1] - Selected Resource
      if (jQuery('#' + shortcode_id + '_wpbc_selected_resource').length > 0) {
        if (jQuery('#' + shortcode_id + '_wpbc_selected_resource').val() !== null // FixIn: 8.2.1.12.
        && parseInt(jQuery('#' + shortcode_id + '_wpbc_selected_resource').val()) > 0) {
          wpbc_shortcode += ' selected_type=' + jQuery('#' + shortcode_id + '_wpbc_selected_resource').val().trim();
        }
      }

      // [bookingselect label='Tada'] - Label
      if (jQuery('#' + shortcode_id + '_wpbc_text_label').length > 0) {
        if ('' !== jQuery('#' + shortcode_id + '_wpbc_text_label').val().trim()) {
          wpbc_shortcode += ' label=\'' + jQuery('#' + shortcode_id + '_wpbc_text_label').val().trim().replace(/'/gi, '') + '\'';
        }
      }

      // [bookingselect first_option_title='Tada'] - First  Option
      if (jQuery('#' + shortcode_id + '_wpbc_first_option_title').length > 0) {
        if ('' !== jQuery('#' + shortcode_id + '_wpbc_first_option_title').val().trim()) {
          wpbc_shortcode += ' first_option_title=\'' + jQuery('#' + shortcode_id + '_wpbc_first_option_title').val().trim().replace(/'/gi, '') + '\'';
        }
      }
    }

    // -------------------------------------------------------------------------------------------------------------
    // [bookingtimeline] - Options relative only to this shortcode.
    // -------------------------------------------------------------------------------------------------------------
    if ('bookingtimeline' === shortcode_id) {
      // Visually update
      var wpbc_is_matrix__view_days_num_temp = wpbc_shortcode_config__update_elements_in_timeline();
      var wpbc_is_matrix = wpbc_is_matrix__view_days_num_temp[0];
      var view_days_num_temp = wpbc_is_matrix__view_days_num_temp[1];

      // : view_days_num
      if (view_days_num_temp != 30) {
        wpbc_shortcode += ' view_days_num=' + view_days_num_temp;
      }
      // : header_title
      if (jQuery('#' + shortcode_id + '_wpbc_text_label_timeline').length > 0) {
        var header_title_temp = jQuery('#' + shortcode_id + '_wpbc_text_label_timeline').val().trim();
        header_title_temp = header_title_temp.replace(/'/gi, '');
        if (header_title_temp != '') {
          wpbc_shortcode += ' header_title=\'' + header_title_temp + '\'';
        }
      }
      // : scroll_month
      if (jQuery('#' + shortcode_id + '_wpbc_scroll_timeline_scroll_month').is(':visible') && jQuery('#' + shortcode_id + '_wpbc_scroll_timeline_scroll_month').length > 0 && parseInt(jQuery('#' + shortcode_id + '_wpbc_scroll_timeline_scroll_month').val().trim()) !== 0) {
        wpbc_shortcode += ' scroll_month=' + parseInt(jQuery('#' + shortcode_id + '_wpbc_scroll_timeline_scroll_month').val().trim());
      }
      // : scroll_day
      if (jQuery('#' + shortcode_id + '_wpbc_scroll_timeline_scroll_days').is(':visible') && jQuery('#' + shortcode_id + '_wpbc_scroll_timeline_scroll_days').length > 0 && parseInt(jQuery('#' + shortcode_id + '_wpbc_scroll_timeline_scroll_days').val().trim()) !== 0) {
        wpbc_shortcode += ' scroll_day=' + parseInt(jQuery('#' + shortcode_id + '_wpbc_scroll_timeline_scroll_days').val().trim());
      }

      // :limit_hours
      // FixIn: 7.0.1.17.
      jQuery('.bookingtimeline_view_times').hide();
      if (wpbc_is_matrix && view_days_num_temp == 1 || !wpbc_is_matrix && view_days_num_temp == 30) {
        jQuery('.bookingtimeline_view_times').show();
        var view_times_start_temp = parseInt(jQuery('#bookingtimeline_wpbc_start_end_time_timeline_starttime').val().trim());
        var view_times_end_temp = parseInt(jQuery('#bookingtimeline_wpbc_start_end_time_timeline_endtime').val().trim());
        if (view_times_start_temp != 0 || view_times_end_temp != 24) {
          wpbc_shortcode += ' limit_hours=\'' + view_times_start_temp + ',' + view_times_end_temp + '\'';
        }
      }

      // :scroll_start_date
      if (jQuery('#bookingtimeline_wpbc_start_date_timeline_active').is(':checked') && jQuery('#bookingtimeline_wpbc_start_date_timeline_active').length > 0) {
        wpbc_shortcode += ' scroll_start_date=\'' + jQuery('#bookingtimeline_wpbc_start_date_timeline_year').val().trim() + '-' + jQuery('#bookingtimeline_wpbc_start_date_timeline_month').val().trim() + '-' + jQuery('#bookingtimeline_wpbc_start_date_timeline_day').val().trim() + '\'';
      }
    }

    // -------------------------------------------------------------------------------------------------------------
    // [bookingform  ] - Form Only        -     [bookingform type=1 selected_dates='01.03.2024']
    // -------------------------------------------------------------------------------------------------------------
    if ('bookingform' === shortcode_id) {
      var wpbc_selected_day = jQuery('#' + shortcode_id + '_wpbc_booking_date_day').val().trim();
      if (parseInt(wpbc_selected_day) < 10) {
        wpbc_selected_day = '0' + wpbc_selected_day;
      }
      var wpbc_selected_month = jQuery('#' + shortcode_id + '_wpbc_booking_date_month').val().trim();
      if (parseInt(wpbc_selected_month) < 10) {
        wpbc_selected_month = '0' + wpbc_selected_month;
      }
      wpbc_shortcode += ' selected_dates=\'' + wpbc_selected_day + '.' + wpbc_selected_month + '.' + jQuery('#' + shortcode_id + '_wpbc_booking_date_year').val().trim() + '\'';
    }

    // -------------------------------------------------------------------------------------------------------------
    // [bookingsearch  ] - Options relative only to this shortcode.     [bookingsearch searchresultstitle='{searchresults} Result(s) Found' noresultstitle='Nothing Found']
    // -------------------------------------------------------------------------------------------------------------
    if ('bookingsearch' === shortcode_id) {
      // Check  if we selected 'bookingsearch' | 'bookingsearchresults'
      var wpbc_search_form_results = 'bookingsearch';
      if (jQuery("input[name='bookingsearch_wpbc_search_form_results']:checked").length > 0) {
        wpbc_search_form_results = jQuery("input[name='bookingsearch_wpbc_search_form_results']:checked").val().trim();
      }

      // Show | Hide form  fields for 'bookingsearch' depends from  radio  bution  selection
      if ('bookingsearchresults' === wpbc_search_form_results) {
        wpbc_shortcode = '[bookingsearchresults';
        jQuery('.wpbc_search_availability_form').hide();
      } else {
        jQuery('.wpbc_search_availability_form').show();

        // New page for search results
        if (jQuery('#' + shortcode_id + '_wpbc_search_new_page_enabled').length > 0 && jQuery('#' + shortcode_id + '_wpbc_search_new_page_enabled').is(':checked')) {
          // Show
          jQuery('.' + shortcode_id + '_wpbc_search_new_page_wpbc_sc_searchresults_new_page').show();

          // : Search Results URL
          if (jQuery('#' + shortcode_id + '_wpbc_search_new_page_url').length > 0) {
            var search_results_url_temp = jQuery('#' + shortcode_id + '_wpbc_search_new_page_url').val().trim();
            search_results_url_temp = search_results_url_temp.replace(/'/gi, '');
            if (search_results_url_temp != '') {
              wpbc_shortcode += ' searchresults=\'' + search_results_url_temp + '\'';
            }
          }
        } else {
          // Hide
          jQuery('.' + shortcode_id + '_wpbc_search_new_page_wpbc_sc_searchresults_new_page').hide();
        }

        /*              // FixIn: 10.0.0.41.
                        // : Search Header
                        if ( jQuery( '#' + shortcode_id + '_wpbc_search_header' ).length > 0 ){
                            var search_header_temp = jQuery( '#' + shortcode_id + '_wpbc_search_header' ).val().trim();
                            search_header_temp = search_header_temp.replace( /'/gi, '' );
                            if ( search_header_temp != '' ){
                                wpbc_shortcode += ' searchresultstitle=\'' + search_header_temp + '\'';
                            }
                        }
                        // : Nothing Found
                        if ( jQuery( '#' + shortcode_id + '_wpbc_search_nothing_found' ).length > 0 ){
                            var nothingfound_temp = jQuery( '#' + shortcode_id + '_wpbc_search_nothing_found' ).val().trim();
                            nothingfound_temp = nothingfound_temp.replace( /'/gi, '' );
                            if ( nothingfound_temp != '' ){
                                wpbc_shortcode += ' noresultstitle=\'' + nothingfound_temp + '\'';
                            }
                        }
        */
        // : Users      // [bookingsearch searchresultstitle='{searchresults} Result(s) Found' noresultstitle='Nothing Found' users='3,4543,']
        if (jQuery('#' + shortcode_id + '_wpbc_search_for_users').length > 0) {
          var only_for_users_temp = jQuery('#' + shortcode_id + '_wpbc_search_for_users').val().trim();
          only_for_users_temp = only_for_users_temp.replace(/'/gi, '');
          if (only_for_users_temp != '') {
            wpbc_shortcode += ' users=\'' + only_for_users_temp + '\'';
          }
        }
      }
    }

    // -------------------------------------------------------------------------------------------------------------
    // [bookingedit] , [bookingcustomerlisting] , [bookingresource type=6 show='capacity'] , [booking_confirm]
    // -------------------------------------------------------------------------------------------------------------
    if ('bookingother' === shortcode_id) {
      //TRICK:
      shortcode_id = 'no'; //required for not update booking resource ID

      // Check  if we selected 'bookingsearch' | 'bookingsearchresults'
      var bookingother_shortcode_type = 'bookingsearch';
      if (jQuery("input[name='bookingother_wpbc_shortcode_type']:checked").length > 0) {
        bookingother_shortcode_type = jQuery("input[name='bookingother_wpbc_shortcode_type']:checked").val().trim();
      }

      // Show | Hide sections
      if ('booking_confirm' === bookingother_shortcode_type) {
        wpbc_shortcode = '[booking_confirm';
        jQuery('.bookingother_section_additional').hide();
        jQuery('.bookingother_section_' + bookingother_shortcode_type).show();
      }
      if ('bookingedit' === bookingother_shortcode_type) {
        wpbc_shortcode = '[bookingedit';
        jQuery('.bookingother_section_additional').hide();
        jQuery('.bookingother_section_' + bookingother_shortcode_type).show();
      }
      if ('bookingcustomerlisting' === bookingother_shortcode_type) {
        wpbc_shortcode = '[bookingcustomerlisting';
        jQuery('.bookingother_section_additional').hide();
        jQuery('.bookingother_section_' + bookingother_shortcode_type).show();
      }
      if ('bookingresource' === bookingother_shortcode_type) {
        //TRICK:
        shortcode_id = 'bookingother'; //required to force update booking resource ID

        wpbc_shortcode = '[bookingresource';
        jQuery('.bookingother_section_additional').hide();
        jQuery('.bookingother_section_' + bookingother_shortcode_type).show();
        if (jQuery('#bookingother_wpbc_resource_show').val().trim() != 'title') {
          wpbc_shortcode += ' show=\'' + jQuery('#bookingother_wpbc_resource_show').val().trim() + '\'';
        }
      }
    }

    // [booking-manager-import ...]     ||      [booking-manager-listing ...]
    if ('booking_import_ics' === shortcode_id || 'booking_listing_ics' === shortcode_id) {
      wpbc_shortcode = '[booking-manager-import';
      if ('booking_listing_ics' === shortcode_id) {
        wpbc_shortcode = '[booking-manager-listing';
      }

      ////////////////////////////////////////////////////////////////
      // : .ics feed URL
      ////////////////////////////////////////////////////////////////
      var shortcode_url_temp = '';
      if (jQuery('#' + shortcode_id + '_wpbc_url').length > 0) {
        shortcode_url_temp = jQuery('#' + shortcode_id + '_wpbc_url').val().trim();
        shortcode_url_temp = shortcode_url_temp.replace(/'/gi, '');
        if (shortcode_url_temp != '') {
          wpbc_shortcode += ' url=\'' + shortcode_url_temp + '\'';
        }
      }
      if (shortcode_url_temp == '') {
        // Error:
        wpbc_shortcode = '[ URL is required ';
      } else {
        // VALID:

        ////////////////////////////////////////////////////////////////
        // [... from='' 'from_offset=''  ...]
        ////////////////////////////////////////////////////////////////
        if (jQuery('#' + shortcode_id + '_from').length > 0) {
          var p_from = jQuery('#' + shortcode_id + '_from').val().trim();
          var p_from_offset = jQuery('#' + shortcode_id + '_from_offset').val().trim();
          p_from = p_from.replace(/'/gi, '');
          p_from_offset = p_from_offset.replace(/'/gi, '');
          if ('' != p_from && 'date' != p_from) {
            // Offset

            wpbc_shortcode += ' from=\'' + p_from + '\'';
            if ('any' != p_from && '' != p_from_offset) {
              p_from_offset = parseInt(p_from_offset);
              if (!isNaN(p_from_offset)) {
                wpbc_shortcode += ' from_offset=\'' + p_from_offset + jQuery('#' + shortcode_id + '_from_offset_type').val().trim().charAt(0) + '\'';
              }
            }
          } else if (p_from == 'date' && p_from_offset != '') {
            // If selected Date
            wpbc_shortcode += ' from=\'' + p_from_offset + '\'';
          }
        }

        ////////////////////////////////////////////////////////////////
        // [... until='' 'until_offset=''  ...]
        ////////////////////////////////////////////////////////////////
        if (jQuery('#' + shortcode_id + '_until').length > 0) {
          var p_until = jQuery('#' + shortcode_id + '_until').val().trim();
          var p_until_offset = jQuery('#' + shortcode_id + '_until_offset').val().trim();
          p_until = p_until.replace(/'/gi, '');
          p_until_offset = p_until_offset.replace(/'/gi, '');
          if ('' != p_until && 'date' != p_until) {
            // Offset

            wpbc_shortcode += ' until=\'' + p_until + '\'';
            if ('any' != p_until && '' != p_until_offset) {
              p_until_offset = parseInt(p_until_offset);
              if (!isNaN(p_until_offset)) {
                wpbc_shortcode += ' until_offset=\'' + p_until_offset + jQuery('#' + shortcode_id + '_until_offset_type').val().trim().charAt(0) + '\'';
              }
            }
          } else if (p_until == 'date' && p_until_offset != '') {
            // If selected Date
            wpbc_shortcode += ' until=\'' + p_until_offset + '\'';
          }
        }

        ////////////////////////////////////////////////////////////////
        // Max
        ////////////////////////////////////////////////////////////////
        if (jQuery('#' + shortcode_id + '_conditions_max_num').length > 0) {
          var p_max = parseInt(jQuery('#' + shortcode_id + '_conditions_max_num').val().trim());
          if (p_max != 0) {
            wpbc_shortcode += ' max=' + p_max;
          }
        }

        ////////////////////////////////////////////////////////////////
        // Silence
        ////////////////////////////////////////////////////////////////
        if (jQuery('#' + shortcode_id + '_silence').length > 0) {
          if ('1' === jQuery('#' + shortcode_id + '_silence').val().trim()) {
            wpbc_shortcode += ' silence=1';
          }
        }

        ////////////////////////////////////////////////////////////////
        // is_all_dates_in
        ////////////////////////////////////////////////////////////////
        if (jQuery('#' + shortcode_id + '_conditions_events').length > 0) {
          var p_is_all_dates_in = parseInt(jQuery('#' + shortcode_id + '_conditions_events').val().trim());
          if (p_is_all_dates_in != 0) {
            wpbc_shortcode += ' is_all_dates_in=' + p_is_all_dates_in;
          }
        }

        ////////////////////////////////////////////////////////////////
        // import_conditions
        ////////////////////////////////////////////////////////////////
        if (jQuery('#' + shortcode_id + '_conditions_import').length > 0) {
          var p_import_conditions = jQuery('#' + shortcode_id + '_conditions_import').val().trim();
          p_import_conditions = p_import_conditions.replace(/'/gi, '');
          if (p_import_conditions != '') {
            wpbc_shortcode += ' import_conditions=\'' + p_import_conditions + '\'';
          }
        }
      }
    }

    // -------------------------------------------------------------------------------------------------------------
    // [booking] , [bookingcalendar] , ...  parameters for these shortcodes and others...
    // -------------------------------------------------------------------------------------------------------------
    if (jQuery('#' + shortcode_id + '_wpbc_resource_id').length > 0) {
      if (jQuery('#' + shortcode_id + '_wpbc_resource_id').val() === null) {
        // FixIn: 8.2.1.12.
        jQuery('#wpbc_text_put_in_shortcode').val('---');
        return;
      } else {
        wpbc_shortcode += ' resource_id=' + jQuery('#' + shortcode_id + '_wpbc_resource_id').val().trim();
      }
    }
    if (jQuery('#' + shortcode_id + '_wpbc_custom_form').length > 0) {
      var form_type_temp = jQuery('#' + shortcode_id + '_wpbc_custom_form').val().trim();
      if (form_type_temp != 'standard') wpbc_shortcode += ' form_type=\'' + jQuery('#' + shortcode_id + '_wpbc_custom_form').val().trim() + '\'';
    }
    if (jQuery('#' + shortcode_id + '_wpbc_nummonths').length > 0 && parseInt(jQuery('#' + shortcode_id + '_wpbc_nummonths').val().trim()) > 1) {
      wpbc_shortcode += ' nummonths=' + jQuery('#' + shortcode_id + '_wpbc_nummonths').val().trim();
    }
    if (jQuery('#' + shortcode_id + '_wpbc_startmonth_active').length > 0 && jQuery('#' + shortcode_id + '_wpbc_startmonth_active').is(':checked')) {
      wpbc_shortcode += ' startmonth=\'' + jQuery('#' + shortcode_id + '_wpbc_startmonth_year').val().trim() + '-' + jQuery('#' + shortcode_id + '_wpbc_startmonth_month').val().trim() + '\'';
    }
    if (jQuery('#' + shortcode_id + '_wpbc_calendar_dates_start_active').length > 0 && jQuery('#' + shortcode_id + '_wpbc_calendar_dates_start_active').is(':checked')) {
      wpbc_shortcode += ' calendar_dates_start=\'' + jQuery('#' + shortcode_id + '_wpbc_calendar_dates_start_year').val().trim() + '-' + jQuery('#' + shortcode_id + '_wpbc_calendar_dates_start_month').val().trim() + '-' + jQuery('#' + shortcode_id + '_wpbc_calendar_dates_start_date').val().trim() + '\'';
    }
    if (jQuery('#' + shortcode_id + '_wpbc_calendar_dates_end_active').length > 0 && jQuery('#' + shortcode_id + '_wpbc_calendar_dates_end_active').is(':checked')) {
      wpbc_shortcode += ' calendar_dates_end=\'' + jQuery('#' + shortcode_id + '_wpbc_calendar_dates_end_year').val().trim() + '-' + jQuery('#' + shortcode_id + '_wpbc_calendar_dates_end_month').val().trim() + '-' + jQuery('#' + shortcode_id + '_wpbc_calendar_dates_end_date').val().trim() + '\'';
    }
    if (jQuery('#' + shortcode_id + '_wpbc_aggregate').length > 0) {
      var wpbc_aggregate_temp = jQuery('#' + shortcode_id + '_wpbc_aggregate').val();
      if (wpbc_aggregate_temp != null && wpbc_aggregate_temp.length > 0) {
        wpbc_aggregate_temp = wpbc_aggregate_temp.join(';');
        if (wpbc_aggregate_temp != 0) {
          // Check about 0=>'None'
          wpbc_shortcode += ' aggregate=\'' + wpbc_aggregate_temp + '\'';
          if (jQuery('#' + shortcode_id + '_wpbc_aggregate__bookings_only').is(':checked')) {
            wpbc_options_arr.push('{aggregate type=bookings_only}');
          }
        }
      }
    }

    // -------------------------------------------------------------------------------------------------------------
    // Option Param
    // -------------------------------------------------------------------------------------------------------------
    // Options : Size
    var wpbc_options_size = '';
    if (jQuery('#' + shortcode_id + '_wpbc_size_enabled').length > 0 && jQuery('#' + shortcode_id + '_wpbc_size_enabled').is(':checked')) {
      // options='{calendar months_num_in_row=2 width=100% cell_height=40px}'

      wpbc_options_size += '{calendar';
      wpbc_options_size += ' ' + 'months_num_in_row=' + Math.min(parseInt(jQuery('#' + shortcode_id + '_wpbc_size_months_num_in_row').val().trim()), parseInt(jQuery('#' + shortcode_id + '_wpbc_nummonths').val().trim()));
      wpbc_options_size += ' ' + 'width=' + parseInt(jQuery('#' + shortcode_id + '_wpbc_size_calendar_width').val().trim()) + jQuery('#' + shortcode_id + '_wpbc_size_calendar_width_px_pr').val().trim();
      wpbc_options_size += ' ' + 'cell_height=' + parseInt(jQuery('#' + shortcode_id + '_wpbc_size_calendar_cell_height').val().trim()) + 'px';
      wpbc_options_size += '}';
      wpbc_options_arr.push(wpbc_options_size);
    }

    // Options: Days number depend on   Weekday
    if (jQuery('#' + shortcode_id + 'wpbc_select_day_weekday_textarea').length > 0) {
      wpbc_options_size = jQuery('#' + shortcode_id + 'wpbc_select_day_weekday_textarea').val().trim();
      if (wpbc_options_size.length > 0) {
        wpbc_options_arr.push(wpbc_options_size);
      }
    }

    // Options: Days number depend on   SEASON
    if (jQuery('#' + shortcode_id + 'wpbc_select_day_season_textarea').length > 0) {
      wpbc_options_size = jQuery('#' + shortcode_id + 'wpbc_select_day_season_textarea').val().trim();
      if (wpbc_options_size.length > 0) {
        wpbc_options_arr.push(wpbc_options_size);
      }
    }

    // Options: Start weekday depend on   SEASON
    if (jQuery('#' + shortcode_id + 'wpbc_start_day_season_textarea').length > 0) {
      wpbc_options_size = jQuery('#' + shortcode_id + 'wpbc_start_day_season_textarea').val().trim();
      if (wpbc_options_size.length > 0) {
        wpbc_options_arr.push(wpbc_options_size);
      }
    }

    // Option: Days number depend on from  DATE
    if (jQuery('#' + shortcode_id + 'wpbc_select_day_fordate_textarea').length > 0) {
      wpbc_options_size = jQuery('#' + shortcode_id + 'wpbc_select_day_fordate_textarea').val().trim();
      if (wpbc_options_size.length > 0) {
        wpbc_options_arr.push(wpbc_options_size);
      }
    }
    if (wpbc_options_arr.length > 0) {
      wpbc_shortcode += ' options=\'' + wpbc_options_arr.join(',') + '\'';
    }
  }
  wpbc_shortcode += ']';
  jQuery('#wpbc_text_put_in_shortcode').val(wpbc_shortcode);
}

/**
 * Open TinyMCE Modal */
function wpbc_tiny_btn_click(tag) {
  // FixIn: 9.0.1.5.
  jQuery('#wpbc_tiny_modal').wpbc_my_modal({
    keyboard: false,
    backdrop: true,
    show: true
  });
  // FixIn: 8.3.3.99.
  jQuery("#wpbc_text_gettenberg_section_id").val('');
}

/**
 * Open TinyMCE Modal */
function wpbc_tiny_close() {
  jQuery('#wpbc_tiny_modal').wpbc_my_modal('hide'); // FixIn: 9.0.1.5.
}

/* ------------------------------------------------------------------------------------------------------------------ */
/** Send Text */
/* ------------------------------------------------------------------------------------------------------------------ */
/**
 * Send text  to editor */
function wpbc_send_text_to_editor(h) {
  // FixIn: 8.3.3.99
  if (typeof wpbc_send_text_to_gutenberg == 'function') {
    var is_send = wpbc_send_text_to_gutenberg(h);
    if (true === is_send) {
      return;
    }
  }
  var ed,
    mce = typeof tinymce != 'undefined',
    qt = typeof QTags != 'undefined';
  if (!wpActiveEditor) {
    if (mce && tinymce.activeEditor) {
      ed = tinymce.activeEditor;
      wpActiveEditor = ed.id;
    } else if (!qt) {
      return false;
    }
  } else if (mce) {
    if (tinymce.activeEditor && (tinymce.activeEditor.id == 'mce_fullscreen' || tinymce.activeEditor.id == 'wp_mce_fullscreen')) ed = tinymce.activeEditor;else ed = tinymce.get(wpActiveEditor);
  }
  if (ed && !ed.isHidden()) {
    // restore caret position on IE
    if (tinymce.isIE && ed.windowManager.insertimagebookmark) ed.selection.moveToBookmark(ed.windowManager.insertimagebookmark);
    if (h.indexOf('[caption') !== -1) {
      if (ed.wpSetImgCaption) h = ed.wpSetImgCaption(h);
    } else if (h.indexOf('[gallery') !== -1) {
      if (ed.plugins.wpgallery) h = ed.plugins.wpgallery._do_gallery(h);
    } else if (h.indexOf('[embed') === 0) {
      if (ed.plugins.wordpress) h = ed.plugins.wordpress._setEmbed(h);
    }
    ed.execCommand('mceInsertContent', false, h);
  } else if (qt) {
    QTags.insertContent(h);
  } else {
    document.getElementById(wpActiveEditor).value += h;
  }
  try {
    tb_remove();
  } catch (e) {}
  ;
}

/**
 * RESOURCES PAGE: Open TinyMCE Modal */
function wpbc_resource_page_btn_click(resource_id, shortcode_default_value = '') {
  // FixIn: 9.0.1.5.
  jQuery('#wpbc_tiny_modal').wpbc_my_modal({
    keyboard: false,
    backdrop: true,
    show: true
  });

  // Disable some options - selection of booking resource - because we configure it only for specific booking resource, where we clicked.
  var shortcode_arr = ['booking', 'bookingcalendar', 'bookingform'];
  for (var shortcde_key in shortcode_arr) {
    var shortcode_id = shortcode_arr[shortcde_key];
    jQuery('#' + shortcode_id + '_wpbc_resource_id').prop('disabled', false);
    jQuery('#' + shortcode_id + "_wpbc_resource_id option[value='" + resource_id + "']").prop('selected', true).trigger('change');
    jQuery('#' + shortcode_id + '_wpbc_resource_id').prop('disabled', true);
  }

  // Hide left  navigation  items
  //        jQuery( ".wpbc_shortcode_config_navigation_column .wpbc_settings_navigation_item" ).hide();
  jQuery("#wpbc_shortcode_config__nav_tab__booking").show();
  jQuery("#wpbc_shortcode_config__nav_tab__bookingcalendar").show();

  // Hide | Show Insert  button  for booking resource page
  jQuery(".wpbc_tiny_button__insert_to_editor").hide();
  jQuery(".wpbc_tiny_button__insert_to_resource").show();
}

/**
 * Get Shortcode Value from  shortcode text field in PopUp shortcode Config dialog and insert  into DIV and INPUT TEXT field near specific booking resource.
 *  But it takes ID  of booking resource,  where to  insert  this shortcode only from  'booking' section  of Config Dialog. usually  such  booking resource  disabled there!
 *  e.g.: jQuery( "#booking_wpbc_resource_id" ).val()
 *
 * @param shortcode_val
 */
function wpbc_send_text_to_resource(shortcode_val) {
  // FixIn: 10.3.0.8.
  var resource_id = 1;
  if (jQuery("#booking_wpbc_resource_id").length) {
    resource_id = jQuery("#booking_wpbc_resource_id").val();
  }
  jQuery('#div_booking_resource_shortcode_' + resource_id).html(shortcode_val);
  jQuery('#booking_resource_shortcode_' + resource_id).val(shortcode_val);
  jQuery('#booking_resource_shortcode_' + resource_id).trigger('change');

  // Scroll
  if ('function' === typeof wpbc_scroll_to) {
    wpbc_scroll_to('#div_booking_resource_shortcode_' + jQuery("#booking_wpbc_resource_id").val());
  }
}

/* R E S E T */
function wpbc_shortcode_config__reset(shortcode_val) {
  jQuery('#' + shortcode_val + '_wpbc_startmonth_active').prop('checked', false).trigger('change');
  jQuery('#' + shortcode_val + '_wpbc_calendar_dates_start_active').prop('checked', false).trigger('change');
  jQuery('#' + shortcode_val + '_wpbc_calendar_dates_end_active').prop('checked', false).trigger('change');
  jQuery('#' + shortcode_val + '_wpbc_aggregate option:selected').prop('selected', false);
  jQuery('#' + shortcode_val + '_wpbc_aggregate option:eq(0)').prop('selected', true);
  jQuery('#' + shortcode_val + '_wpbc_aggregate__bookings_only').prop('checked', false).trigger('change');
  jQuery('#' + shortcode_val + '_wpbc_custom_form option:eq(0)').prop('selected', true);
  jQuery('#' + shortcode_val + '_wpbc_nummonths option:eq(0)').prop('selected', true);
  jQuery('#' + shortcode_val + '_wpbc_size_enabled').prop('checked', false).trigger('change');
  wpbc_shortcode_config__select_day_weekday__reset(shortcode_val + 'wpbc_select_day_weekday');
  wpbc_shortcode_config__select_day_season__reset(shortcode_val + 'wpbc_select_day_season');
  wpbc_shortcode_config__start_day_season__reset(shortcode_val + 'wpbc_start_day_season');
  wpbc_shortcode_config__select_day_fordate__reset(shortcode_val + 'wpbc_select_day_fordate');

  // Reset  for [bookingselect] shortcode params
  jQuery('#' + shortcode_val + '_wpbc_multiple_resources option:selected').prop('selected', false);
  jQuery('#' + shortcode_val + '_wpbc_multiple_resources option:eq(0)').prop('selected', true).trigger('change');
  jQuery('#' + shortcode_val + '_wpbc_selected_resource option:eq(0)').prop('selected', true).trigger('change');
  jQuery('#' + shortcode_val + '_wpbc_text_label').val('').trigger('change');
  jQuery('#' + shortcode_val + '_wpbc_first_option_title').val('').trigger('change');

  // Reset  for [bookingtimeline] shortcode params
  jQuery('#' + shortcode_val + '_wpbc_text_label_timeline').val('').trigger('change');
  jQuery('#' + shortcode_val + '_wpbc_scroll_timeline_scroll_month option[value="0"]').prop('selected', true).trigger('change');
  jQuery('#' + shortcode_val + '_wpbc_scroll_timeline_scroll_days option[value="0"]').prop('selected', true).trigger('change');
  jQuery('#' + shortcode_val + '_wpbc_start_date_timeline_active').prop('checked', false).trigger('change');
  jQuery('#' + shortcode_val + '_wpbc_start_end_time_timeline_starttime option[value="0"]').prop('selected', true).trigger('change');
  jQuery('#' + shortcode_val + '_wpbc_start_end_time_timeline_endtime option[value="24"]').prop('selected', true).trigger('change');
  jQuery('input[name="' + shortcode_val + '_wpbc_view_mode_timeline_months_num_in_row"][value="30"]').prop('checked', true).trigger('change');
  jQuery('#' + shortcode_val + '_wpbc_start_date_timeline_year option[value="' + new Date().getFullYear() + '"]').prop('selected', true).trigger('change');
  jQuery('#' + shortcode_val + '_wpbc_start_date_timeline_month option[value="' + (new Date().getMonth() + 1) + '"]').prop('selected', true).trigger('change');
  jQuery('#' + shortcode_val + '_wpbc_start_date_timeline_day option[value="' + new Date().getDate() + '"]').prop('selected', true).trigger('change');

  // Reset  for [bookingform] shortcode params
  jQuery('#' + shortcode_val + '_wpbc_booking_date_year option[value="' + new Date().getFullYear() + '"]').prop('selected', true).trigger('change');
  jQuery('#' + shortcode_val + '_wpbc_booking_date_month option[value="' + (new Date().getMonth() + 1) + '"]').prop('selected', true).trigger('change');
  jQuery('#' + shortcode_val + '_wpbc_booking_date_day option[value="' + new Date().getDate() + '"]').prop('selected', true).trigger('change');

  // Reset  for [[bookingsearch ...] shortcode params
  jQuery('#' + shortcode_val + '_wpbc_search_new_page_url').val('').trigger('change');
  jQuery('#' + shortcode_val + '_wpbc_search_new_page_enabled').prop('checked', false).trigger('change');
  // jQuery( '#' + shortcode_val + '_wpbc_search_header' ).val( '' ).trigger('change');                           // FixIn: 10.0.0.41.
  // jQuery( '#' + shortcode_val + '_wpbc_search_nothing_found' ).val( '' ).trigger('change');
  jQuery('#' + shortcode_val + '_wpbc_search_for_users').val('').trigger('change');
  jQuery('input[name="' + shortcode_val + '_wpbc_search_form_results"][value="bookingsearch"]').prop('checked', true).trigger('change');

  // Reset  for [bookingedit] , [bookingcustomerlisting] , [bookingresource type=6 show='capacity'] , [booking_confirm]
  jQuery('input[name="' + shortcode_val + '_wpbc_shortcode_type"][value="booking_confirm"]').prop('checked', true).trigger('change');

  // booking_import_ics , booking_listing_ics
  jQuery('#' + shortcode_val + '_wpbc_url').val('').trigger('change');
  jQuery('#' + shortcode_val + '_from option[value="today"]').prop('selected', true).trigger('change');
  jQuery('#' + shortcode_val + '_from_offset').val('').trigger('change');
  jQuery('#' + shortcode_val + '_from_offset_type option:eq(0)').prop('selected', true).trigger('change');
  jQuery('#' + shortcode_val + '_until option[value="any"]').prop('selected', true).trigger('change');
  jQuery('#' + shortcode_val + '_until_offset').val('').trigger('change');
  jQuery('#' + shortcode_val + '_until_offset_type option:eq(0)').prop('selected', true).trigger('change');
  jQuery('#' + shortcode_val + '_conditions_import option:eq(0)').prop('selected', true).trigger('change');
  jQuery('#' + shortcode_val + '_conditions_events option[value="1"]').prop('selected', true).trigger('change');
  jQuery('#' + shortcode_val + '_conditions_max_num option[value="0"]').prop('selected', true).trigger('change');
  jQuery('#' + shortcode_val + '_silence option[value="0"]').prop('selected', true).trigger('change');
}

/* ------------------------------------------------------------------------------------------------------------------ */
/**
 *  SHORTCODE_CONFIG
 * */
/* ------------------------------------------------------------------------------------------------------------------ */

/**
 * When click on menu item in "Left Vertical Navigation" panel  in shortcode config popup
 */
function wpbc_shortcode_config_click_show_section(_this, section_id_to_show, shortcode_name) {
  // Menu
  jQuery(_this).parents('.wpbc_settings_flex_container').find('.wpbc_settings_navigation_item_active').removeClass('wpbc_settings_navigation_item_active');
  jQuery(_this).parents('.wpbc_settings_navigation_item').addClass('wpbc_settings_navigation_item_active');

  // Content
  jQuery(_this).parents('.wpbc_settings_flex_container').find('.wpbc_sc_container__shortcode').hide();
  jQuery(section_id_to_show).show();

  // Scroll
  if ('function' === typeof wpbc_scroll_to) {
    wpbc_scroll_to(section_id_to_show);
  }
  // Set - Shortcode Type
  jQuery('#wpbc_shortcode_type').val(shortcode_name);

  // Parse shortcode params
  wpbc_set_shortcode();
}

/**
 * Do Next / Prior step
 * @param _this		button  this
 * @param step		'prior' | 'next'
 */
function wpbc_shortcode_config_content_toolbar__next_prior(_this, step) {
  var j_work_nav_tab;
  var submenu_selected = jQuery(_this).parents('.wpbc_sc_container__shortcode').find('.wpbc_sc_container__shortcode_section:visible').find('.wpdevelop-submenu-tab-selected:visible');
  if (submenu_selected.length) {
    if ('next' === step) {
      j_work_nav_tab = submenu_selected.nextAll('a.nav-tab:visible').first();
    } else {
      j_work_nav_tab = submenu_selected.prevAll('a.nav-tab:visible').first();
    }
    if (j_work_nav_tab.length) {
      j_work_nav_tab.trigger('click');
      return;
    }
  }
  if ('next' === step) {
    j_work_nav_tab = jQuery(_this).parents('.wpbc_sc_container__shortcode').find('.nav-tab.nav-tab-active:visible').nextAll('a.nav-tab:visible').first();
  } else {
    j_work_nav_tab = jQuery(_this).parents('.wpbc_sc_container__shortcode').find('.nav-tab.nav-tab-active:visible').prevAll('a.nav-tab:visible').first();
  }
  if (j_work_nav_tab.length) {
    j_work_nav_tab.trigger('click');
  }
}

/**
 * Condition:   {select-day condition="weekday" for="5" value="3"}
 */
function wpbc_shortcode_config__select_day_weekday__add(id) {
  var condition_rule_arr = [];
  for (var weekday_num = 0; weekday_num < 8; weekday_num++) {
    if (jQuery('#' + id + '__weekday_' + weekday_num).is(':checked')) {
      var days_to_select = jQuery('#' + id + '__days_number_' + weekday_num).val().trim();
      // Remove all words except digits and , and -
      days_to_select = days_to_select.replace(/[^0-9,-]/g, '');
      days_to_select = days_to_select.replace(/[,]{2,}/g, ',');
      days_to_select = days_to_select.replace(/[-]{2,}/g, '-');
      jQuery('#' + id + '__days_number_' + weekday_num).val(days_to_select);
      if ('' !== days_to_select) {
        condition_rule_arr.push('{select-day condition="weekday" for="' + weekday_num + '" value="' + days_to_select + '"}');
      } else {
        // Red highlight fields,  if some required fields are empty
        if ('function' === typeof wpbc_field_highlight && '' === jQuery('#' + id + '__days_number_' + weekday_num).val()) {
          wpbc_field_highlight('#' + id + '__days_number_' + weekday_num);
        }
      }
    }
  }
  var condition_rule = condition_rule_arr.join(',');
  jQuery('#' + id + '_textarea').val(condition_rule);
  wpbc_set_shortcode();
}
function wpbc_shortcode_config__select_day_weekday__reset(id) {
  for (var weekday_num = 0; weekday_num < 8; weekday_num++) {
    jQuery('#' + id + '__days_number_' + weekday_num).val('');
    if (jQuery('#' + id + '__weekday_' + weekday_num).is(':checked')) {
      jQuery('#' + id + '__weekday_' + weekday_num).prop('checked', false);
    }
  }
  jQuery('#' + id + '_textarea').val('');
  wpbc_set_shortcode();
}

/**
 * Condition:   {select-day condition="season" for="High season" value="7-14,20"}
 */
function wpbc_shortcode_config__select_day_season__add(id) {
  var season_filter_name = jQuery('#' + id + '__season_filter_name option:selected').text().trim();
  // Escape quote symbols
  season_filter_name = season_filter_name.replace(/[\""]/g, '\\"');
  var days_number = jQuery('#' + id + '__days_number').val().trim();
  // Remove all words except digits and , and -
  days_number = days_number.replace(/[^0-9,-]/g, '');
  days_number = days_number.replace(/[,]{2,}/g, ',');
  days_number = days_number.replace(/[-]{2,}/g, '-');
  jQuery('#' + id + '__days_number').val(days_number);
  if ('' != days_number && '' != season_filter_name && 0 != jQuery('#' + id + '__season_filter_name').val()) {
    var exist_configuration = jQuery('#' + id + '_textarea').val();
    exist_configuration = exist_configuration.replaceAll("},{", '}~~{');
    var condition_rule_arr = exist_configuration.split('~~');

    // Remove empty spaces from  array : '' | ""
    condition_rule_arr = condition_rule_arr.filter(function (n) {
      return n;
    });
    condition_rule_arr.push('{select-day condition="season" for="' + season_filter_name + '" value="' + days_number + '"}');

    // Remove duplicates from  the array
    condition_rule_arr = condition_rule_arr.filter(function (item, pos) {
      return condition_rule_arr.indexOf(item) === pos;
    });
    var condition_rule = condition_rule_arr.join(',');
    jQuery('#' + id + '_textarea').val(condition_rule);
    wpbc_set_shortcode();
  }

  // Red highlight fields,  if some required fields are empty
  if ('function' === typeof wpbc_field_highlight && '' === jQuery('#' + id + '__days_number').val()) {
    wpbc_field_highlight('#' + id + '__days_number');
  }
  if ('function' === typeof wpbc_field_highlight && '0' === jQuery('#' + id + '__season_filter_name').val()) {
    wpbc_field_highlight('#' + id + '__season_filter_name');
  }
}
function wpbc_shortcode_config__select_day_season__reset(id) {
  jQuery('#' + id + '__season_filter_name option:eq(0)').prop('selected', true);
  jQuery('#' + id + '__days_number').val('');
  jQuery('#' + id + '_textarea').val('');
  wpbc_set_shortcode();
}

/**
 * Condition:   {start-day condition="season" for="Low season" value="0,1,5"}
 */
function wpbc_shortcode_config__start_day_season__add(id) {
  var season_filter_name = jQuery('#' + id + '__season_filter_name option:selected').text().trim();
  // Escape quote symbols
  season_filter_name = season_filter_name.replace(/[\""]/g, '\\"');
  if ('' != season_filter_name && 0 != jQuery('#' + id + '__season_filter_name').val()) {
    var activated_weekdays = [];
    for (var weekday_num = 0; weekday_num < 8; weekday_num++) {
      if (jQuery('#' + id + '__weekday_' + weekday_num).is(':checked')) {
        activated_weekdays.push(weekday_num);
      }
    }
    activated_weekdays = activated_weekdays.join(',');
    if ('' != activated_weekdays) {
      var exist_configuration = jQuery('#' + id + '_textarea').val();
      exist_configuration = exist_configuration.replaceAll("},{", '}~~{');
      var condition_rule_arr = exist_configuration.split('~~');

      // Remove empty spaces from  array : '' | ""
      condition_rule_arr = condition_rule_arr.filter(function (n) {
        return n;
      });
      condition_rule_arr.push('{start-day condition="season" for="' + season_filter_name + '" value="' + activated_weekdays + '"}');

      // Remove duplicates from  the array
      condition_rule_arr = condition_rule_arr.filter(function (item, pos) {
        return condition_rule_arr.indexOf(item) === pos;
      });
      var condition_rule = condition_rule_arr.join(',');
      jQuery('#' + id + '_textarea').val(condition_rule);
      wpbc_set_shortcode();
    }
  }

  // Red highlight fields,  if some required fields are empty
  if ('function' === typeof wpbc_field_highlight && '0' === jQuery('#' + id + '__season_filter_name').val()) {
    wpbc_field_highlight('#' + id + '__season_filter_name');
  }
}
function wpbc_shortcode_config__start_day_season__reset(id) {
  jQuery('#' + id + '__season_filter_name option:eq(0)').prop('selected', true);
  for (var weekday_num = 0; weekday_num < 8; weekday_num++) {
    if (jQuery('#' + id + '__weekday_' + weekday_num).is(':checked')) {
      jQuery('#' + id + '__weekday_' + weekday_num).prop('checked', false);
    }
  }
  jQuery('#' + id + '_textarea').val('');
  wpbc_set_shortcode();
}

/**
 * Condition:   {select-day condition="date" for="2023-10-01" value="20,25,30-35"}
 */
function wpbc_shortcode_config__select_day_fordate__add(id) {
  var start_date__fordate = jQuery('#' + id + '__date').val().trim();
  // Remove all words except digits and , and -
  start_date__fordate = start_date__fordate.replace(/[^0-9-]/g, '');
  var globalRegex = new RegExp(/^\d{4}-[01]{1}\d{1}-[0123]{1}\d{1}$/, 'g');
  var is_valid_date = globalRegex.test(start_date__fordate);
  if (!is_valid_date) {
    start_date__fordate = '';
  }
  jQuery('#' + id + '__date').val(start_date__fordate);
  var days_number = jQuery('#' + id + '__days_number').val().trim();
  // Remove all words except digits and , and -
  days_number = days_number.replace(/[^0-9,-]/g, '');
  days_number = days_number.replace(/[,]{2,}/g, ',');
  days_number = days_number.replace(/[-]{2,}/g, '-');
  jQuery('#' + id + '__days_number').val(days_number);
  if ('' != days_number && '' != start_date__fordate && 0 != jQuery('#' + id + '__season_filter_name').val()) {
    var exist_configuration = jQuery('#' + id + '_textarea').val();
    exist_configuration = exist_configuration.replaceAll("},{", '}~~{');
    var condition_rule_arr = exist_configuration.split('~~');

    // Remove empty spaces from  array : '' | ""
    condition_rule_arr = condition_rule_arr.filter(function (n) {
      return n;
    });
    condition_rule_arr.push('{select-day condition="date" for="' + start_date__fordate + '" value="' + days_number + '"}');

    // Remove duplicates from  the array
    condition_rule_arr = condition_rule_arr.filter(function (item, pos) {
      return condition_rule_arr.indexOf(item) === pos;
    });
    var condition_rule = condition_rule_arr.join(',');
    jQuery('#' + id + '_textarea').val(condition_rule);
    wpbc_set_shortcode();
  } else
    // Red highlight fields,  if some required fields are empty
    if ('function' === typeof wpbc_field_highlight && '' === jQuery('#' + id + '__date').val()) {
      wpbc_field_highlight('#' + id + '__date');
    }
  if ('function' === typeof wpbc_field_highlight && '' === jQuery('#' + id + '__days_number').val()) {
    wpbc_field_highlight('#' + id + '__days_number');
  }
}
function wpbc_shortcode_config__select_day_fordate__reset(id) {
  jQuery('#' + id + '__date').val('');
  jQuery('#' + id + '__days_number').val('');
  jQuery('#' + id + '_textarea').val('');
  wpbc_set_shortcode();
}
function wpbc_shortcode_config__update_elements_in_timeline() {
  var wpbc_is_matrix = false;
  if (jQuery('#bookingtimeline_wpbc_multiple_resources').length > 0) {
    var bookingtimeline_wpbc_multiple_resources_temp = jQuery('#bookingtimeline_wpbc_multiple_resources').val();
    if (bookingtimeline_wpbc_multiple_resources_temp != null && bookingtimeline_wpbc_multiple_resources_temp.length > 0) {
      jQuery("input[name='bookingtimeline_wpbc_view_mode_timeline_months_num_in_row']").prop("disabled", false);
      jQuery(".wpbc_sc_container__shortcode_bookingtimeline label.wpbc-form-radio").show();
      if (bookingtimeline_wpbc_multiple_resources_temp.length > 1 || bookingtimeline_wpbc_multiple_resources_temp.length == 1 && bookingtimeline_wpbc_multiple_resources_temp[0] == '0') {
        // Matrix
        wpbc_is_matrix = true;
        jQuery("input[name='bookingtimeline_wpbc_view_mode_timeline_months_num_in_row'][value='90']").prop("disabled", true);
        jQuery("input[name='bookingtimeline_wpbc_view_mode_timeline_months_num_in_row'][value='90']").parents('.wpbc-form-radio').hide();
        jQuery("input[name='bookingtimeline_wpbc_view_mode_timeline_months_num_in_row'][value='365']").prop("disabled", true);
        jQuery("input[name='bookingtimeline_wpbc_view_mode_timeline_months_num_in_row'][value='365']").parents('.wpbc-form-radio').hide();
      } else {
        // Single
        jQuery("input[name='bookingtimeline_wpbc_view_mode_timeline_months_num_in_row'][value='1']").prop("disabled", true);
        jQuery("input[name='bookingtimeline_wpbc_view_mode_timeline_months_num_in_row'][value='1']").parents('.wpbc-form-radio').hide();
        jQuery("input[name='bookingtimeline_wpbc_view_mode_timeline_months_num_in_row'][value='7']").prop("disabled", true);
        jQuery("input[name='bookingtimeline_wpbc_view_mode_timeline_months_num_in_row'][value='7']").parents('.wpbc-form-radio').hide();
        jQuery("input[name='bookingtimeline_wpbc_view_mode_timeline_months_num_in_row'][value='60']").prop("disabled", true);
        jQuery("input[name='bookingtimeline_wpbc_view_mode_timeline_months_num_in_row'][value='60']").parents('.wpbc-form-radio').hide();
      }
      if (jQuery("input[name='bookingtimeline_wpbc_view_mode_timeline_months_num_in_row']:checked").is(':disabled')) {
        jQuery("input[name='bookingtimeline_wpbc_view_mode_timeline_months_num_in_row'][value='30']").prop("checked", true);
      }
    }
  }
  var view_days_num_temp = 30;
  if (jQuery("input[name='bookingtimeline_wpbc_view_mode_timeline_months_num_in_row']:checked").length > 0) {
    var view_days_num_temp = parseInt(jQuery("input[name='bookingtimeline_wpbc_view_mode_timeline_months_num_in_row']:checked").val().trim());
  }

  ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  // Hide or Show Scrolling Days and Months, depending on from type of view and number of booking resources
  ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  jQuery("#wpbc_bookingtimeline_scroll_month,#wpbc_bookingtimeline_scroll_day").prop("disabled", false);
  jQuery(".wpbc_bookingtimeline_scroll_month,.wpbc_bookingtimeline_scroll_day").show();
  // Matrix //////////////////////////////////////////////
  if (wpbc_is_matrix && (view_days_num_temp == 1 || view_days_num_temp == 7) // Day | Week view
  ) {
    jQuery("#wpbc_bookingtimeline_scroll_month").prop("disabled", true); // Scroll Month NOT working
    jQuery('.wpbc_bookingtimeline_scroll_month').hide();
  }
  if (wpbc_is_matrix && (view_days_num_temp == 30 || view_days_num_temp == 60) // Month view
  ) {
    jQuery("#wpbc_bookingtimeline_scroll_day").prop("disabled", true); // Scroll Days NOT working
    jQuery('.wpbc_bookingtimeline_scroll_day').hide();
  }
  // Single //////////////////////////////////////////////
  if (!wpbc_is_matrix && (view_days_num_temp == 30 || view_days_num_temp == 90) // Month | 3 Months view (like week view)
  ) {
    jQuery("#wpbc_bookingtimeline_scroll_month").prop("disabled", true); // Scroll Month NOT working
    jQuery('.wpbc_bookingtimeline_scroll_month').hide();
  }
  if (!wpbc_is_matrix && view_days_num_temp == 365 // Year view
  ) {
    jQuery("#wpbc_bookingtimeline_scroll_day").prop("disabled", true); // Scroll Days NOT working
    jQuery('.wpbc_bookingtimeline_scroll_day').hide();
  }
  ////////////////////////////////////////////////////////////////////////////////////////////////////////////////

  return [wpbc_is_matrix, view_days_num_temp];
}
jQuery(document).ready(function () {
  // -----------------------------------------------------------------------------------------------------
  // [booking ... ]

  var shortcode_arr = ['booking', 'bookingcalendar', 'bookingselect', 'bookingtimeline', 'bookingform', 'bookingsearch', 'bookingother', 'booking_import_ics', 'booking_listing_ics'];
  for (var shortcde_key in shortcode_arr) {
    var id = shortcode_arr[shortcde_key];

    // -------------------------------------------------------------------------------------------------------------
    // Hide by Size sections
    // -------------------------------------------------------------------------------------------------------------
    jQuery('.' + id + '_wpbc_size_wpbc_sc_calendar_size').hide();

    // options :: Show / Hide SIZE calendar  section
    jQuery('#' + id + '_wpbc_size_enabled').on('change', {
      'id': id
    }, function (event) {
      if (jQuery('#' + event.data.id + '_wpbc_size_enabled').is(':checked')) {
        jQuery('.' + event.data.id + '_wpbc_size_wpbc_sc_calendar_size').show();
      } else {
        jQuery('.' + event.data.id + '_wpbc_size_wpbc_sc_calendar_size').hide();
      }
    });

    // If we changed number of months in 'Setup Size & Structure' then  change general 'Visible months' number      // FixIn: 10.0.0.4.
    jQuery('#' + id + '_wpbc_size_months_num_in_row' // - Month Num in Row
    ).on('change', {
      'id': id
    }, function (event) {
      jQuery('#' + event.data.id + '_wpbc_nummonths option[value="' + parseInt(jQuery('#' + event.data.id + '_wpbc_size_months_num_in_row').val().trim()) + '"]').prop('selected', true); //.trigger('change');
      if ('function' === typeof wpbc_field_highlight) {
        wpbc_field_highlight('#' + event.data.id + '_wpbc_nummonths');
      }
    });

    // -------------------------------------------------------------------------------------------------------------
    // Update Shortcode on changing: Size
    // -------------------------------------------------------------------------------------------------------------
    jQuery('#' + id + '_wpbc_size_enabled' // Size On | Off
    + ',#' + id + '_wpbc_size_months_num_in_row' // - Month Num in Row
    + ',#' + id + '_wpbc_size_calendar_width' // - Width
    + ',#' + id + '_wpbc_size_calendar_width_px_pr' // - Width PS | %
    + ',#' + id + '_wpbc_size_calendar_cell_height' // - Cell Height
    + ',#' + id + 'wpbc_select_day_weekday_textarea' // Rule Weekday
    + ',#' + id + 'wpbc_select_day_season_textarea' // Rule Season
    + ',#' + id + 'wpbc_start_day_season_textarea' // Rule Season - Start day
    + ',#' + id + 'wpbc_select_day_fordate_textarea' // Rule Date
    + ',#' + id + '_wpbc_resource_id' // Resource ID
    + ',#' + id + '_wpbc_custom_form' // Custom Form
    + ',#' + id + '_wpbc_nummonths' // Num Months
    + ',#' + id + '_wpbc_startmonth_active' // Start Month Enable
    + ',#' + id + '_wpbc_startmonth_year' //  - Year
    + ',#' + id + '_wpbc_startmonth_month' //  - Month
    + ',#' + id + '_wpbc_calendar_dates_start_active' // Start Month Enable
    + ',#' + id + '_wpbc_calendar_dates_start_year' //  - Year
    + ',#' + id + '_wpbc_calendar_dates_start_month' //  - Month
    + ',#' + id + '_wpbc_calendar_dates_start_date' //  - Month
    + ',#' + id + '_wpbc_calendar_dates_end_active' // Start Month Enable
    + ',#' + id + '_wpbc_calendar_dates_end_year' //  - Year
    + ',#' + id + '_wpbc_calendar_dates_end_month' //  - Month
    + ',#' + id + '_wpbc_calendar_dates_end_date' //  - Month
    + ',#' + id + '_wpbc_aggregate' // Aggregate
    + ',#' + id + '_wpbc_aggregate__bookings_only' // aggregate option
    + ',#' + id + '_wpbc_multiple_resources' // [bookingselect] - Multiple Resources
    + ',#' + id + '_wpbc_selected_resource' // [bookingselect] - Selected Resource
    + ',#' + id + '_wpbc_text_label' // [bookingselect] - Label
    + ',#' + id + '_wpbc_first_option_title' // [bookingselect] - First  Option

    // TimeLine
    + ",input[name='" + id + "_wpbc_view_mode_timeline_months_num_in_row']" + ',#' + id + '_wpbc_text_label_timeline' + ',#' + id + '_wpbc_scroll_timeline_scroll_days' + ',#' + id + '_wpbc_scroll_timeline_scroll_month' + ',#' + id + '_wpbc_start_date_timeline_active' + ',#' + id + '_wpbc_start_date_timeline_year' + ',#' + id + '_wpbc_start_date_timeline_month' + ',#' + id + '_wpbc_start_date_timeline_day' + ',#' + id + '_wpbc_start_end_time_timeline_starttime' + ',#' + id + '_wpbc_start_end_time_timeline_endtime'

    // Form Only
    + ',#' + id + '_wpbc_booking_date_year' + ',#' + id + '_wpbc_booking_date_month' + ',#' + id + '_wpbc_booking_date_day'

    // [bookingsearch ...]
    + ",input[name='" + id + "_wpbc_search_form_results']" + ',#' + id + '_wpbc_search_new_page_enabled' + ',#' + id + '_wpbc_search_new_page_url'
    // +',#' + id + '_wpbc_search_header'                       // FixIn: 10.0.0.41.
    // +',#' + id + '_wpbc_search_nothing_found'
    + ',#' + id + '_wpbc_search_for_users'

    // [bookingother ... ]
    + ",input[name='" + id + "_wpbc_shortcode_type']" + ',#' + id + '_wpbc_resource_show'

    //booking_import_ics , booking_listing_ics
    + ',#' + id + '_wpbc_url' + ',#' + id + '_from' + ',#' + id + '_from_offset' + ',#' + id + '_from_offset_type' + ',#' + id + '_until' + ',#' + id + '_until_offset' + ',#' + id + '_until_offset_type' + ',#' + id + '_conditions_import' + ',#' + id + '_conditions_events' + ',#' + id + '_conditions_max_num' + ',#' + id + '_silence').on('change', {
      'id': id
    }, function (event) {
      //console.log( 'on change wpbc_set_shortcode', event.data.id );
      wpbc_set_shortcode();
    });
  }
  // -----------------------------------------------------------------------------------------------------
  wpbc_set_shortcode();
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
