"use strict";

jQuery(document).ready(function ($) {
  /**
   * Ajax save.
   */
  $(document).on('click', '.elementor-save-skin', function () {
    const $button = $(this);
    const $controlWrapper = $button.closest('.elementor-control-content');
    const $select = $controlWrapper.find('.elementor-control-input-wrapper select');
    const selectedSkin = $select.val();
    const html_id = $button.attr('id');
    const nonce = WPBC_Ajax.nonce;

    // UI feedback: processing state.
    $button.attr('saved_title', $button.text());
    $button.text($button.attr('processing_title') + '...');
    $button.prop('disabled', true);
    $.ajax({
      url: WPBC_Ajax.ajax_url,
      type: 'POST',
      data: {
        action: 'wpbc_save_calendar_skin',
        skin: selectedSkin,
        _ajax_nonce: nonce,
        html_id: html_id
      },
      success: function (response) {
        // Restore button state.
        if (html_id) {
          const $btn = $(document.getElementById(html_id));
          $btn.prop('disabled', false).text($btn.attr('saved_title')).removeAttr('saved_title');
        }
        if (!response.success) {
          console.warn('Skin save failed:', response.data || 'Unknown error');
          return;
        }
        const savedSkinUrl = response.data?.url_full;
        console.log('Skin saved successfully:', savedSkinUrl);
      },
      error: function () {
        console.error('AJAX error occurred during skin save.');
        // Optional: restore button UI.
        if (html_id) {
          const $btn = $('#' + html_id);
          $btn.prop('disabled', false).text($btn.attr('saved_title')).removeAttr('saved_title');
        }
      }
    });
  });
  $(document).on('click', '.wpbc-reset-dates-button', function () {
    // Clear input values directly
    $('input[data-setting="wpbc_booking_calendar_dates_start"]').val('').trigger('input');
    $('input[data-setting="wpbc_booking_calendar_dates_end"]').val('').trigger('input');
    $('input[data-setting="wpbc_booking_calendar_startmonth"]').val('').trigger('input');
  });
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5jbHVkZXMvZWxlbWVudG9yLWJvb2tpbmctZm9ybS9fb3V0L3dwYmMtZWxlbWVudG9yLmpzIiwibmFtZXMiOlsialF1ZXJ5IiwiZG9jdW1lbnQiLCJyZWFkeSIsIiQiLCJvbiIsIiRidXR0b24iLCIkY29udHJvbFdyYXBwZXIiLCJjbG9zZXN0IiwiJHNlbGVjdCIsImZpbmQiLCJzZWxlY3RlZFNraW4iLCJ2YWwiLCJodG1sX2lkIiwiYXR0ciIsIm5vbmNlIiwiV1BCQ19BamF4IiwidGV4dCIsInByb3AiLCJhamF4IiwidXJsIiwiYWpheF91cmwiLCJ0eXBlIiwiZGF0YSIsImFjdGlvbiIsInNraW4iLCJfYWpheF9ub25jZSIsInN1Y2Nlc3MiLCJyZXNwb25zZSIsIiRidG4iLCJnZXRFbGVtZW50QnlJZCIsInJlbW92ZUF0dHIiLCJjb25zb2xlIiwid2FybiIsInNhdmVkU2tpblVybCIsInVybF9mdWxsIiwibG9nIiwiZXJyb3IiLCJ0cmlnZ2VyIl0sInNvdXJjZXMiOlsiaW5jbHVkZXMvZWxlbWVudG9yLWJvb2tpbmctZm9ybS9fc3JjL3dwYmMtZWxlbWVudG9yLmpzIl0sInNvdXJjZXNDb250ZW50IjpbImpRdWVyeSggZG9jdW1lbnQgKS5yZWFkeSggZnVuY3Rpb24gKCQpIHtcclxuXHJcblx0LyoqXHJcblx0ICogQWpheCBzYXZlLlxyXG5cdCAqL1xyXG5cdCQoIGRvY3VtZW50ICkub24oICdjbGljaycsICcuZWxlbWVudG9yLXNhdmUtc2tpbicsIGZ1bmN0aW9uICgpIHtcclxuXHJcblxyXG5cdFx0Y29uc3QgJGJ1dHRvbiAgICAgICAgID0gJCggdGhpcyApO1xyXG5cdFx0Y29uc3QgJGNvbnRyb2xXcmFwcGVyID0gJGJ1dHRvbi5jbG9zZXN0KCAnLmVsZW1lbnRvci1jb250cm9sLWNvbnRlbnQnICk7XHJcblx0XHRjb25zdCAkc2VsZWN0ICAgICAgICAgPSAkY29udHJvbFdyYXBwZXIuZmluZCggJy5lbGVtZW50b3ItY29udHJvbC1pbnB1dC13cmFwcGVyIHNlbGVjdCcgKTtcclxuXHRcdGNvbnN0IHNlbGVjdGVkU2tpbiAgICA9ICRzZWxlY3QudmFsKCk7XHJcblxyXG5cdFx0Y29uc3QgaHRtbF9pZCA9ICRidXR0b24uYXR0ciggJ2lkJyApO1xyXG5cdFx0Y29uc3Qgbm9uY2UgICA9IFdQQkNfQWpheC5ub25jZTtcclxuXHJcblx0XHQvLyBVSSBmZWVkYmFjazogcHJvY2Vzc2luZyBzdGF0ZS5cclxuXHRcdCRidXR0b24uYXR0ciggJ3NhdmVkX3RpdGxlJywgJGJ1dHRvbi50ZXh0KCkgKTtcclxuXHRcdCRidXR0b24udGV4dCggJGJ1dHRvbi5hdHRyKCAncHJvY2Vzc2luZ190aXRsZScgKSArICcuLi4nICk7XHJcblx0XHQkYnV0dG9uLnByb3AoICdkaXNhYmxlZCcsIHRydWUgKTtcclxuXHJcblx0XHQkLmFqYXgoXHJcblx0XHRcdHtcclxuXHRcdFx0XHR1cmw6IFdQQkNfQWpheC5hamF4X3VybCxcclxuXHRcdFx0XHR0eXBlOiAnUE9TVCcsXHJcblx0XHRcdFx0ZGF0YToge1xyXG5cdFx0XHRcdFx0YWN0aW9uOiAnd3BiY19zYXZlX2NhbGVuZGFyX3NraW4nLFxyXG5cdFx0XHRcdFx0c2tpbjogc2VsZWN0ZWRTa2luLFxyXG5cdFx0XHRcdFx0X2FqYXhfbm9uY2U6IG5vbmNlLFxyXG5cdFx0XHRcdFx0aHRtbF9pZDogaHRtbF9pZCxcclxuXHRcdFx0XHR9LFxyXG5cdFx0XHRcdHN1Y2Nlc3M6IGZ1bmN0aW9uIChyZXNwb25zZSkge1xyXG5cclxuXHRcdFx0XHRcdC8vIFJlc3RvcmUgYnV0dG9uIHN0YXRlLlxyXG5cdFx0XHRcdFx0aWYgKCBodG1sX2lkICkge1xyXG5cdFx0XHRcdFx0XHRjb25zdCAkYnRuID0gJCggZG9jdW1lbnQuZ2V0RWxlbWVudEJ5SWQoIGh0bWxfaWQgKSApO1xyXG5cdFx0XHRcdFx0XHQkYnRuLnByb3AoICdkaXNhYmxlZCcsIGZhbHNlICkudGV4dCggJGJ0bi5hdHRyKCAnc2F2ZWRfdGl0bGUnICkgKS5yZW1vdmVBdHRyKCAnc2F2ZWRfdGl0bGUnICk7XHJcblx0XHRcdFx0XHR9XHJcblxyXG5cdFx0XHRcdFx0aWYgKCAhIHJlc3BvbnNlLnN1Y2Nlc3MgKSB7XHJcblx0XHRcdFx0XHRcdGNvbnNvbGUud2FybiggJ1NraW4gc2F2ZSBmYWlsZWQ6JywgcmVzcG9uc2UuZGF0YSB8fCAnVW5rbm93biBlcnJvcicgKTtcclxuXHRcdFx0XHRcdFx0cmV0dXJuO1xyXG5cdFx0XHRcdFx0fVxyXG5cclxuXHRcdFx0XHRcdGNvbnN0IHNhdmVkU2tpblVybCA9IHJlc3BvbnNlLmRhdGE/LnVybF9mdWxsO1xyXG5cdFx0XHRcdFx0Y29uc29sZS5sb2coICdTa2luIHNhdmVkIHN1Y2Nlc3NmdWxseTonLCBzYXZlZFNraW5VcmwgKTtcclxuXHRcdFx0XHR9LFxyXG5cdFx0XHRcdGVycm9yICA6IGZ1bmN0aW9uICgpIHtcclxuXHJcblx0XHRcdFx0XHRjb25zb2xlLmVycm9yKCAnQUpBWCBlcnJvciBvY2N1cnJlZCBkdXJpbmcgc2tpbiBzYXZlLicgKTtcclxuXHRcdFx0XHRcdC8vIE9wdGlvbmFsOiByZXN0b3JlIGJ1dHRvbiBVSS5cclxuXHRcdFx0XHRcdGlmICggaHRtbF9pZCApIHtcclxuXHRcdFx0XHRcdFx0Y29uc3QgJGJ0biA9ICQoICcjJyArIGh0bWxfaWQgKTtcclxuXHRcdFx0XHRcdFx0JGJ0bi5wcm9wKCAnZGlzYWJsZWQnLCBmYWxzZSApLnRleHQoICRidG4uYXR0ciggJ3NhdmVkX3RpdGxlJyApICkucmVtb3ZlQXR0ciggJ3NhdmVkX3RpdGxlJyApO1xyXG5cdFx0XHRcdFx0fVxyXG5cdFx0XHRcdH1cclxuXHRcdFx0fVxyXG5cdFx0KTtcclxuXHR9ICk7XHJcblxyXG5cdCQoIGRvY3VtZW50ICkub24oICdjbGljaycsICcud3BiYy1yZXNldC1kYXRlcy1idXR0b24nLCBmdW5jdGlvbiAoKSB7XHJcblx0XHQvLyBDbGVhciBpbnB1dCB2YWx1ZXMgZGlyZWN0bHlcclxuXHRcdCQoICdpbnB1dFtkYXRhLXNldHRpbmc9XCJ3cGJjX2Jvb2tpbmdfY2FsZW5kYXJfZGF0ZXNfc3RhcnRcIl0nICkudmFsKCAnJyApLnRyaWdnZXIoICdpbnB1dCcgKTtcclxuXHRcdCQoICdpbnB1dFtkYXRhLXNldHRpbmc9XCJ3cGJjX2Jvb2tpbmdfY2FsZW5kYXJfZGF0ZXNfZW5kXCJdJyApLnZhbCggJycgKS50cmlnZ2VyKCAnaW5wdXQnICk7XHJcblx0XHQkKCAnaW5wdXRbZGF0YS1zZXR0aW5nPVwid3BiY19ib29raW5nX2NhbGVuZGFyX3N0YXJ0bW9udGhcIl0nICkudmFsKCAnJyApLnRyaWdnZXIoICdpbnB1dCcgKTtcclxuXHR9ICk7XHJcbn0gKTtcclxuIl0sIm1hcHBpbmdzIjoiOztBQUFBQSxNQUFNLENBQUVDLFFBQVMsQ0FBQyxDQUFDQyxLQUFLLENBQUUsVUFBVUMsQ0FBQyxFQUFFO0VBRXRDO0FBQ0Q7QUFDQTtFQUNDQSxDQUFDLENBQUVGLFFBQVMsQ0FBQyxDQUFDRyxFQUFFLENBQUUsT0FBTyxFQUFFLHNCQUFzQixFQUFFLFlBQVk7SUFHOUQsTUFBTUMsT0FBTyxHQUFXRixDQUFDLENBQUUsSUFBSyxDQUFDO0lBQ2pDLE1BQU1HLGVBQWUsR0FBR0QsT0FBTyxDQUFDRSxPQUFPLENBQUUsNEJBQTZCLENBQUM7SUFDdkUsTUFBTUMsT0FBTyxHQUFXRixlQUFlLENBQUNHLElBQUksQ0FBRSx5Q0FBMEMsQ0FBQztJQUN6RixNQUFNQyxZQUFZLEdBQU1GLE9BQU8sQ0FBQ0csR0FBRyxDQUFDLENBQUM7SUFFckMsTUFBTUMsT0FBTyxHQUFHUCxPQUFPLENBQUNRLElBQUksQ0FBRSxJQUFLLENBQUM7SUFDcEMsTUFBTUMsS0FBSyxHQUFLQyxTQUFTLENBQUNELEtBQUs7O0lBRS9CO0lBQ0FULE9BQU8sQ0FBQ1EsSUFBSSxDQUFFLGFBQWEsRUFBRVIsT0FBTyxDQUFDVyxJQUFJLENBQUMsQ0FBRSxDQUFDO0lBQzdDWCxPQUFPLENBQUNXLElBQUksQ0FBRVgsT0FBTyxDQUFDUSxJQUFJLENBQUUsa0JBQW1CLENBQUMsR0FBRyxLQUFNLENBQUM7SUFDMURSLE9BQU8sQ0FBQ1ksSUFBSSxDQUFFLFVBQVUsRUFBRSxJQUFLLENBQUM7SUFFaENkLENBQUMsQ0FBQ2UsSUFBSSxDQUNMO01BQ0NDLEdBQUcsRUFBRUosU0FBUyxDQUFDSyxRQUFRO01BQ3ZCQyxJQUFJLEVBQUUsTUFBTTtNQUNaQyxJQUFJLEVBQUU7UUFDTEMsTUFBTSxFQUFFLHlCQUF5QjtRQUNqQ0MsSUFBSSxFQUFFZCxZQUFZO1FBQ2xCZSxXQUFXLEVBQUVYLEtBQUs7UUFDbEJGLE9BQU8sRUFBRUE7TUFDVixDQUFDO01BQ0RjLE9BQU8sRUFBRSxTQUFBQSxDQUFVQyxRQUFRLEVBQUU7UUFFNUI7UUFDQSxJQUFLZixPQUFPLEVBQUc7VUFDZCxNQUFNZ0IsSUFBSSxHQUFHekIsQ0FBQyxDQUFFRixRQUFRLENBQUM0QixjQUFjLENBQUVqQixPQUFRLENBQUUsQ0FBQztVQUNwRGdCLElBQUksQ0FBQ1gsSUFBSSxDQUFFLFVBQVUsRUFBRSxLQUFNLENBQUMsQ0FBQ0QsSUFBSSxDQUFFWSxJQUFJLENBQUNmLElBQUksQ0FBRSxhQUFjLENBQUUsQ0FBQyxDQUFDaUIsVUFBVSxDQUFFLGFBQWMsQ0FBQztRQUM5RjtRQUVBLElBQUssQ0FBRUgsUUFBUSxDQUFDRCxPQUFPLEVBQUc7VUFDekJLLE9BQU8sQ0FBQ0MsSUFBSSxDQUFFLG1CQUFtQixFQUFFTCxRQUFRLENBQUNMLElBQUksSUFBSSxlQUFnQixDQUFDO1VBQ3JFO1FBQ0Q7UUFFQSxNQUFNVyxZQUFZLEdBQUdOLFFBQVEsQ0FBQ0wsSUFBSSxFQUFFWSxRQUFRO1FBQzVDSCxPQUFPLENBQUNJLEdBQUcsQ0FBRSwwQkFBMEIsRUFBRUYsWUFBYSxDQUFDO01BQ3hELENBQUM7TUFDREcsS0FBSyxFQUFJLFNBQUFBLENBQUEsRUFBWTtRQUVwQkwsT0FBTyxDQUFDSyxLQUFLLENBQUUsdUNBQXdDLENBQUM7UUFDeEQ7UUFDQSxJQUFLeEIsT0FBTyxFQUFHO1VBQ2QsTUFBTWdCLElBQUksR0FBR3pCLENBQUMsQ0FBRSxHQUFHLEdBQUdTLE9BQVEsQ0FBQztVQUMvQmdCLElBQUksQ0FBQ1gsSUFBSSxDQUFFLFVBQVUsRUFBRSxLQUFNLENBQUMsQ0FBQ0QsSUFBSSxDQUFFWSxJQUFJLENBQUNmLElBQUksQ0FBRSxhQUFjLENBQUUsQ0FBQyxDQUFDaUIsVUFBVSxDQUFFLGFBQWMsQ0FBQztRQUM5RjtNQUNEO0lBQ0QsQ0FDRCxDQUFDO0VBQ0YsQ0FBRSxDQUFDO0VBRUgzQixDQUFDLENBQUVGLFFBQVMsQ0FBQyxDQUFDRyxFQUFFLENBQUUsT0FBTyxFQUFFLDBCQUEwQixFQUFFLFlBQVk7SUFDbEU7SUFDQUQsQ0FBQyxDQUFFLHlEQUEwRCxDQUFDLENBQUNRLEdBQUcsQ0FBRSxFQUFHLENBQUMsQ0FBQzBCLE9BQU8sQ0FBRSxPQUFRLENBQUM7SUFDM0ZsQyxDQUFDLENBQUUsdURBQXdELENBQUMsQ0FBQ1EsR0FBRyxDQUFFLEVBQUcsQ0FBQyxDQUFDMEIsT0FBTyxDQUFFLE9BQVEsQ0FBQztJQUN6RmxDLENBQUMsQ0FBRSx3REFBeUQsQ0FBQyxDQUFDUSxHQUFHLENBQUUsRUFBRyxDQUFDLENBQUMwQixPQUFPLENBQUUsT0FBUSxDQUFDO0VBQzNGLENBQUUsQ0FBQztBQUNKLENBQUUsQ0FBQyIsImlnbm9yZUxpc3QiOltdfQ==
