<?php

/**
 * Theme options / General / Posts
 *
 * @package vamtam/pur
 */

return array(

	array(
		'label'       => esc_html__( 'Pagination Type', 'pur' ),
		'description' => esc_html__( 'Also used for portfolio', 'pur' ),
		'id'          => 'pagination-type',
		'type'        => 'select',
		'choices'     => array(
			'paged'              => esc_html__( 'Paged', 'pur' ),
			'load-more'          => esc_html__( 'Load more button', 'pur' ),
			'infinite-scrolling' => esc_html__( 'Infinite scrolling', 'pur' ),
		),
	),

	array(
		'label'       => esc_html__( 'Show "Related Posts" in Single Post View', 'pur' ),
		'description' => esc_html__( 'Enabling this option will show more posts from the same category when viewing a single post.', 'pur' ),
		'id'          => 'show-related-posts',
		'type'        => 'switch',
		'transport'   => 'postMessage',
	),

	array(
		'label'     => esc_html__( '"Related Posts" title', 'pur' ),
		'id'        => 'related-posts-title',
		'type'      => 'text',
		'transport' => 'postMessage',
	),

	array(
		'label'     => esc_html__( 'Meta Information', 'pur' ),
		'id'        => 'post-meta',
		'type'      => 'multicheck',
		'transport' => 'postMessage',
		'choices'   => array(
			'author'   => esc_html__( 'Post Author', 'pur' ),
			'tax'      => esc_html__( 'Categories and Tags', 'pur' ),
			'date'     => esc_html__( 'Timestamp', 'pur' ),
			'comments' => esc_html__( 'Comment Count', 'pur' ),
		),
	),

	array(
		'label'       => esc_html__( 'Show Featured Image on Single Posts', 'pur' ),
		'id'          => 'show-single-post-image',
		'description' => esc_html__( 'Please note, that this option works only for Blog Post Format Image.', 'pur' ),
		'type'        => 'switch',
		'transport'   => 'postMessage',
	),

	array(
		'label'       => esc_html__( 'Post Archive Layout', 'pur' ),
		'description' => '',
		'id'          => 'archive-layout',
		'type'        => 'radio',
		'choices'     => array(
			'normal' => esc_html__( 'Large', 'pur' ),
			'mosaic' => esc_html__( 'Small', 'pur' ),
		),
	),

);

